/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.logs;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.OperatorAnnotation;
import com.datatorrent.api.annotation.Stateless;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.lib.logs.InformationExtractor;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@OperatorAnnotation(partitionable=true)
public class ApacheLogParseMapOutputOperator
extends BaseOperator {
    private String logRegex = ApacheLogParseMapOutputOperator.getDefaultAccessLogRegex();
    private String[] regexGroups = ApacheLogParseMapOutputOperator.getDefaultRegexGroups();
    private final Map<String, InformationExtractor> infoExtractors = new HashMap<String, InformationExtractor>();
    private transient Pattern accessLogPattern;
    public final transient DefaultInputPort<String> data = new DefaultInputPort<String>(){

        public void process(String s) {
            try {
                ApacheLogParseMapOutputOperator.this.processTuple(s);
            }
            catch (ParseException ex) {
                throw new RuntimeException("Could not parse the input string", ex);
            }
        }
    };
    public final transient DefaultOutputPort<Map<String, Object>> output = new DefaultOutputPort();
    private static final Logger LOG = LoggerFactory.getLogger(ApacheLogParseMapOutputOperator.class);

    public String[] getRegexGroups() {
        return Arrays.copyOf(this.regexGroups, this.regexGroups.length);
    }

    public void setRegexGroups(String[] regexGroups) {
        this.regexGroups = Arrays.copyOf(regexGroups, regexGroups.length);
    }

    public String getLogRegex() {
        return this.logRegex;
    }

    public void setLogRegex(String logRegex) {
        this.logRegex = logRegex;
        this.accessLogPattern = Pattern.compile(this.logRegex, 34);
    }

    private static String getDefaultAccessLogRegex() {
        String regex1 = "^([\\d\\.]+)";
        String regex2 = " (\\S+)";
        String regex3 = " (\\S+)";
        String regex4 = " \\[([\\w:/]+\\s[+\\-]\\d{4})\\]";
        String regex5 = " \"[A-Z]+ (.+?) HTTP/\\S+\"";
        String regex6 = " (\\d{3})";
        String regex7 = " (\\d+)";
        String regex8 = " \"([^\"]+)\"";
        String regex9 = " \"([^\"]+)\"";
        String regex10 = ".*";
        return regex1 + regex2 + regex3 + regex4 + regex5 + regex6 + regex7 + regex8 + regex9 + regex10;
    }

    private static String[] getDefaultRegexGroups() {
        return new String[]{null, "ip", null, "userid", "time", "url", "status", "bytes", "referer", "agent"};
    }

    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.accessLogPattern = Pattern.compile(this.logRegex, 34);
        for (Map.Entry<String, InformationExtractor> entry : this.infoExtractors.entrySet()) {
            entry.getValue().setup();
        }
    }

    public void teardown() {
        for (Map.Entry<String, InformationExtractor> entry : this.infoExtractors.entrySet()) {
            entry.getValue().teardown();
        }
        super.teardown();
    }

    public void processTuple(String line) throws ParseException {
        Matcher accessLogEntryMatcher = this.accessLogPattern.matcher(line);
        if (accessLogEntryMatcher.matches()) {
            HashMap<String, Object> outputMap = new HashMap<String, Object>();
            for (int i = 0; i < this.regexGroups.length; ++i) {
                Map<String, Object> m;
                if (this.regexGroups[i] == null) continue;
                String value = accessLogEntryMatcher.group(i).trim();
                outputMap.put(this.regexGroups[i], value);
                InformationExtractor extractor = this.infoExtractors.get(this.regexGroups[i]);
                if (extractor == null || (m = extractor.extractInformation(value)) == null) continue;
                outputMap.putAll(m);
            }
            this.output.emit(outputMap);
        }
    }

    public void registerInformationExtractor(String group, InformationExtractor extractor) {
        this.infoExtractors.put(group, extractor);
    }
}

