/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.logs;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.OperatorAnnotation;
import com.datatorrent.api.annotation.Stateless;
import com.datatorrent.common.util.BaseOperator;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Stateless
@OperatorAnnotation(partitionable=true)
public class ApacheLogParseOperator
extends BaseOperator {
    public final transient DefaultInputPort<String> data = new DefaultInputPort<String>(){

        public void process(String s) {
            try {
                ApacheLogParseOperator.this.processTuple(s);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    };
    public final transient DefaultOutputPort<String> outputIPAddress = new DefaultOutputPort();
    public final transient DefaultOutputPort<String> outputUrl = new DefaultOutputPort();
    public final transient DefaultOutputPort<String> outputStatusCode = new DefaultOutputPort();
    public final transient DefaultOutputPort<Long> outputBytes = new DefaultOutputPort();
    public final transient DefaultOutputPort<String> outputReferer = new DefaultOutputPort();
    public final transient DefaultOutputPort<String> outputAgent = new DefaultOutputPort();

    protected static String getAccessLogRegex() {
        String regex1 = "^([\\d\\.]+)";
        String regex2 = " (\\S+)";
        String regex3 = " (\\S+)";
        String regex4 = " \\[([\\w:/]+\\s[+\\-]\\d{4})\\]";
        String regex5 = " \"[A-Z]+ (.+?) HTTP/\\S+\"";
        String regex6 = " (\\d{3})";
        String regex7 = " (\\d+)";
        String regex8 = " \"([^\"]+)\"";
        String regex9 = " \"([^\"]+)\"";
        String regex10 = ".*";
        return regex1 + regex2 + regex3 + regex4 + regex5 + regex6 + regex7 + regex8 + regex9 + regex10;
    }

    public void processTuple(String line) throws ParseException {
        Pattern accessLogPattern = Pattern.compile(ApacheLogParseOperator.getAccessLogRegex(), 34);
        Matcher accessLogEntryMatcher = accessLogPattern.matcher(line);
        if (accessLogEntryMatcher.matches()) {
            String ipAddr = accessLogEntryMatcher.group(1);
            String url = accessLogEntryMatcher.group(5);
            String httpStatusCode = accessLogEntryMatcher.group(6);
            long numOfBytes = Long.parseLong(accessLogEntryMatcher.group(7));
            String referer = accessLogEntryMatcher.group(8);
            String agent = accessLogEntryMatcher.group(9);
            this.outputIPAddress.emit((Object)ipAddr);
            this.outputUrl.emit((Object)url);
            this.outputStatusCode.emit((Object)httpStatusCode);
            this.outputBytes.emit((Object)numOfBytes);
            this.outputReferer.emit((Object)referer);
            this.outputAgent.emit((Object)agent);
        }
    }
}

