/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.logs;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.Stateless;
import com.datatorrent.common.util.BaseOperator;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Stateless
public class ApacheVirtualLogParseOperator
extends BaseOperator {
    protected static final String dateFormat = "dd/MMM/yyyy:HH:mm:ss Z";
    public final transient DefaultInputPort<String> data = new DefaultInputPort<String>(){

        public void process(String s) {
            try {
                ApacheVirtualLogParseOperator.this.processTuple(s);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    };
    public final transient DefaultOutputPort<String> outputIPAddress = new DefaultOutputPort();
    public final transient DefaultOutputPort<String> outputUrl = new DefaultOutputPort();
    public final transient DefaultOutputPort<String> outputStatusCode = new DefaultOutputPort();
    public final transient DefaultOutputPort<Map<String, Integer>> outputBytes = new DefaultOutputPort();
    public final transient DefaultOutputPort<String> outputReferer = new DefaultOutputPort();
    public final transient DefaultOutputPort<String> outputAgent = new DefaultOutputPort();
    public final transient DefaultOutputPort<String> outputServerName = new DefaultOutputPort();
    public final transient DefaultOutputPort<String> outputServerName1 = new DefaultOutputPort();
    public final transient DefaultOutputPort<Map<String, String>> outUrlStatus = new DefaultOutputPort();
    public final transient DefaultOutputPort<Map<String, String>> outServerStatus = new DefaultOutputPort();
    public final transient DefaultOutputPort<Integer> clientDataUsage = new DefaultOutputPort();
    public final transient DefaultOutputPort<Integer> viewCount = new DefaultOutputPort();

    protected static String getAccessLogRegex() {
        String regex0 = "^([^\"]+)";
        String regex1 = " ([\\d\\.]+)";
        String regex2 = " (\\S+)";
        String regex3 = " (\\S+)";
        String regex4 = " \\[([\\w:/]+\\s[+\\-]\\d{4})\\]";
        String regex5 = " \"[A-Z]+ (.+?) HTTP/\\S+\"";
        String regex6 = " (\\d{3})";
        String regex7 = " (\\d+)";
        String regex8 = " \"([^\"]+)\"";
        String regex9 = " \"([^\"]+)\"";
        String regex10 = ".*";
        return regex0 + regex1 + regex2 + regex3 + regex4 + regex5 + regex6 + regex7 + regex8 + regex9 + regex10;
    }

    public void processTuple(String line) throws ParseException {
        Pattern accessLogPattern = Pattern.compile(ApacheVirtualLogParseOperator.getAccessLogRegex(), 34);
        Matcher accessLogEntryMatcher = accessLogPattern.matcher(line);
        if (accessLogEntryMatcher.matches()) {
            String serverName = accessLogEntryMatcher.group(1);
            String ipAddr = accessLogEntryMatcher.group(2);
            String url = accessLogEntryMatcher.group(6);
            String httpStatusCode = accessLogEntryMatcher.group(7);
            long numOfBytes = Long.parseLong(accessLogEntryMatcher.group(8));
            String referer = accessLogEntryMatcher.group(9);
            String agent = accessLogEntryMatcher.group(10);
            this.outputIPAddress.emit((Object)ipAddr);
            this.outputUrl.emit((Object)url);
            this.outputStatusCode.emit((Object)httpStatusCode);
            HashMap<String, Integer> ipdata = new HashMap<String, Integer>();
            ipdata.put(ipAddr, (int)numOfBytes);
            this.outputBytes.emit(ipdata);
            this.outputReferer.emit((Object)referer);
            this.outputAgent.emit((Object)agent);
            this.outputServerName.emit((Object)serverName);
            this.outputServerName1.emit((Object)serverName);
            HashMap<String, String> urlStatus = new HashMap<String, String>();
            urlStatus.put(url, httpStatusCode);
            this.outUrlStatus.emit(urlStatus);
            HashMap<String, String> serverStatus = new HashMap<String, String>();
            serverStatus.put(serverName, httpStatusCode);
            this.outServerStatus.emit(serverStatus);
            this.clientDataUsage.emit((Object)((int)numOfBytes));
            this.viewCount.emit((Object)new Integer(1));
        }
    }
}

