/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.logs;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.lib.logs.DimensionObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableDouble;

public class DimensionAggregationUnifier
implements Operator {
    private Map<String, Map<String, MutableDouble>> dataMap = new HashMap<String, Map<String, MutableDouble>>();
    public final transient DefaultOutputPort<Map<String, DimensionObject<String>>> output = new DefaultOutputPort();
    public final transient DefaultInputPort<Map<String, DimensionObject<String>>> input = new DefaultInputPort<Map<String, DimensionObject<String>>>(){

        public void process(Map<String, DimensionObject<String>> tuple) {
            for (Map.Entry<String, DimensionObject<String>> e : tuple.entrySet()) {
                HashMap<String, MutableDouble> obj = (HashMap<String, MutableDouble>)DimensionAggregationUnifier.this.dataMap.get(e.getKey());
                DimensionObject<String> eObj = e.getValue();
                if (obj == null) {
                    obj = new HashMap<String, MutableDouble>();
                    obj.put(eObj.getVal(), new MutableDouble((Number)eObj.getCount()));
                    DimensionAggregationUnifier.this.dataMap.put(e.getKey(), obj);
                    continue;
                }
                MutableDouble n = (MutableDouble)obj.get(eObj.getVal());
                if (n == null) {
                    obj.put(eObj.getVal(), new MutableDouble((Number)eObj.getCount()));
                    continue;
                }
                n.add((Number)eObj.getCount());
            }
        }
    };

    public void setup(Context.OperatorContext context) {
    }

    public void teardown() {
    }

    public void beginWindow(long windowId) {
        this.dataMap = new HashMap<String, Map<String, MutableDouble>>();
    }

    public void endWindow() {
        for (Map.Entry<String, Map<String, MutableDouble>> e : this.dataMap.entrySet()) {
            for (Map.Entry<String, MutableDouble> dimensionValObj : e.getValue().entrySet()) {
                HashMap<String, DimensionObject<String>> outputData = new HashMap<String, DimensionObject<String>>();
                outputData.put(e.getKey(), new DimensionObject<String>(dimensionValObj.getValue(), dimensionValObj.getKey()));
                this.output.emit(outputData);
            }
        }
        this.dataMap.clear();
    }
}

