/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.logs;

import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.api.annotation.OperatorAnnotation;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.api.annotation.Stateless;
import com.datatorrent.lib.util.BaseLineTokenizer;
import com.datatorrent.lib.util.UnifierArrayList;
import java.util.ArrayList;
import java.util.HashMap;

@Stateless
@OperatorAnnotation(partitionable=true)
public class LineToTokenArrayList
extends BaseLineTokenizer {
    protected transient ArrayList<String> tokentuple = null;
    protected transient ArrayList<HashMap<String, ArrayList<String>>> stokentuple = null;
    protected transient HashMap<String, ArrayList<String>> smap = null;
    protected transient ArrayList<String> vals = null;
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<ArrayList<String>> tokens = new DefaultOutputPort<ArrayList<String>>(){

        public Operator.Unifier<ArrayList<String>> getUnifier() {
            return new UnifierArrayList<String>();
        }
    };
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<ArrayList<HashMap<String, ArrayList<String>>>> splittokens = new DefaultOutputPort<ArrayList<HashMap<String, ArrayList<String>>>>(){

        public Operator.Unifier<ArrayList<HashMap<String, ArrayList<String>>>> getUnifier() {
            return new UnifierArrayList<HashMap<String, ArrayList<String>>>();
        }
    };

    @Override
    public void beginProcessTokens() {
        this.tokentuple = new ArrayList();
        this.stokentuple = new ArrayList();
    }

    @Override
    public void processToken(String tok) {
        if (this.tokens.isConnected()) {
            this.tokentuple.add(tok);
        }
        if (this.splittokens.isConnected() && this.hasSplitTokenBy()) {
            super.processToken(tok);
        }
    }

    @Override
    public void beginProcessSubTokens() {
        this.smap = new HashMap(1);
        this.vals = new ArrayList(4);
    }

    @Override
    public void endProcessSubTokens() {
        if (!this.smap.isEmpty()) {
            this.stokentuple.add(this.smap);
        }
        this.smap = null;
        this.vals = null;
    }

    @Override
    public void processSubToken(String subtok) {
        if (this.smap.isEmpty()) {
            this.smap.put(subtok, this.vals);
        } else {
            this.vals.add(subtok);
        }
    }

    @Override
    public void endProcessTokens() {
        if (this.tokens.isConnected()) {
            this.tokens.emit(this.tokentuple);
            this.tokentuple = null;
        }
        if (this.splittokens.isConnected()) {
            this.splittokens.emit(this.stokentuple);
            this.stokentuple = null;
            this.smap = null;
            this.vals = null;
        }
    }
}

