/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.logs;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.lib.logs.DimensionObject;
import com.datatorrent.lib.util.KeyValPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.mutable.MutableDouble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiWindowDimensionAggregation
implements Operator {
    private static final Logger logger = LoggerFactory.getLogger(MultiWindowDimensionAggregation.class);
    private int windowSize = 2;
    private int currentWindow = 0;
    private String timeBucket = "m";
    private String dimensionKeyVal = "0";
    private List<String> dimensionArrayString;
    @NotNull
    private List<int[]> dimensionArray;
    private AggregateOperation operationType = AggregateOperation.SUM;
    private Map<String, Map<String, KeyValPair<MutableDouble, Integer>>> outputMap;
    private Map<Integer, Map<String, Map<String, Number>>> cacheOject;
    private transient List<Pattern> patternList;
    private transient int applicationWindowSize = 500;
    public final transient DefaultOutputPort<Map<String, DimensionObject<String>>> output = new DefaultOutputPort();
    public final transient DefaultInputPort<Map<String, Map<String, Number>>> data = new DefaultInputPort<Map<String, Map<String, Number>>>(){

        public void process(Map<String, Map<String, Number>> tuple) {
            MultiWindowDimensionAggregation.this.cacheOject.put(MultiWindowDimensionAggregation.this.currentWindow, tuple);
            block0: for (Map.Entry<String, Map<String, Number>> tupleEntry : tuple.entrySet()) {
                String tupleKey = tupleEntry.getKey();
                Map<String, Number> tupleValue = tupleEntry.getValue();
                int currentPattern = 0;
                for (Pattern pattern : MultiWindowDimensionAggregation.this.patternList) {
                    Matcher matcher = pattern.matcher(tupleKey);
                    if (matcher.matches()) {
                        String currentPatternString = (String)MultiWindowDimensionAggregation.this.dimensionArrayString.get(currentPattern);
                        HashMap<String, KeyValPair<MutableDouble, Integer>> currentPatternMap = (HashMap<String, KeyValPair<MutableDouble, Integer>>)MultiWindowDimensionAggregation.this.outputMap.get(currentPatternString);
                        if (currentPatternMap == null) {
                            currentPatternMap = new HashMap<String, KeyValPair<MutableDouble, Integer>>();
                            MultiWindowDimensionAggregation.this.outputMap.put(currentPatternString, currentPatternMap);
                        }
                        StringBuilder builder = new StringBuilder(matcher.group(2));
                        for (int i = 1; i < ((int[])MultiWindowDimensionAggregation.this.dimensionArray.get(currentPattern)).length; ++i) {
                            builder.append("," + matcher.group(i + 2));
                        }
                        KeyValPair<MutableDouble, Integer> currentDimensionKeyValPair = (KeyValPair<MutableDouble, Integer>)currentPatternMap.get(builder.toString());
                        if (currentDimensionKeyValPair == null) {
                            currentDimensionKeyValPair = new KeyValPair<MutableDouble, Integer>(new MutableDouble(tupleValue.get(MultiWindowDimensionAggregation.this.dimensionKeyVal)), 1);
                            currentPatternMap.put(builder.toString(), currentDimensionKeyValPair);
                            continue block0;
                        }
                        ((MutableDouble)currentDimensionKeyValPair.getKey()).add(tupleValue.get(MultiWindowDimensionAggregation.this.dimensionKeyVal));
                        currentDimensionKeyValPair.setValue((Integer)currentDimensionKeyValPair.getValue() + 1);
                        continue block0;
                    }
                    ++currentPattern;
                }
            }
        }
    };

    public String getDimensionKeyVal() {
        return this.dimensionKeyVal;
    }

    public void setDimensionKeyVal(String dimensionKeyVal) {
        this.dimensionKeyVal = dimensionKeyVal;
    }

    public String getTimeBucket() {
        return this.timeBucket;
    }

    public void setTimeBucket(String timeBucket) {
        this.timeBucket = timeBucket;
    }

    public List<int[]> getDimensionArray() {
        return this.dimensionArray;
    }

    public void setDimensionArray(List<int[]> dimensionArray) {
        this.dimensionArray = dimensionArray;
        this.dimensionArrayString = new ArrayList<String>();
        for (int[] e : dimensionArray) {
            StringBuilder builder = new StringBuilder("" + e[0]);
            for (int i = 1; i < e.length; ++i) {
                builder.append("," + e[i]);
            }
            this.dimensionArrayString.add(builder.toString());
        }
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public void setup(Context.OperatorContext arg0) {
        if (arg0 != null) {
            this.applicationWindowSize = (Integer)arg0.getValue(Context.OperatorContext.APPLICATION_WINDOW_COUNT);
        }
        if (this.cacheOject == null) {
            this.cacheOject = new HashMap<Integer, Map<String, Map<String, Number>>>(this.windowSize);
        }
        if (this.outputMap == null) {
            this.outputMap = new HashMap<String, Map<String, KeyValPair<MutableDouble, Integer>>>();
        }
        this.setUpPatternList();
    }

    private void setUpPatternList() {
        this.patternList = new ArrayList<Pattern>();
        for (int[] e : this.dimensionArray) {
            StringBuilder builder = new StringBuilder(this.timeBucket + "\\|(\\d+)");
            for (int i = 0; i < e.length; ++i) {
                builder.append("\\|" + e[i] + ":([^\\|]+)");
            }
            Pattern pattern = Pattern.compile(builder.toString());
            this.patternList.add(pattern);
        }
    }

    public void teardown() {
    }

    public void beginWindow(long arg0) {
        Map<String, Map<String, Number>> currentWindowMap = this.cacheOject.get(this.currentWindow);
        if (currentWindowMap == null) {
            currentWindowMap = new HashMap<String, Map<String, Number>>();
        } else {
            block0: for (Map.Entry<String, Map<String, Number>> tupleEntry : currentWindowMap.entrySet()) {
                String tupleKey = tupleEntry.getKey();
                Map<String, Number> tupleValue = tupleEntry.getValue();
                int currentPattern = 0;
                for (Pattern pattern : this.patternList) {
                    Matcher matcher = pattern.matcher(tupleKey);
                    if (matcher.matches()) {
                        String currentPatternString = this.dimensionArrayString.get(currentPattern);
                        Map<String, KeyValPair<MutableDouble, Integer>> currentPatternMap = this.outputMap.get(currentPatternString);
                        if (currentPatternMap == null) continue block0;
                        StringBuilder builder = new StringBuilder(matcher.group(2));
                        for (int i = 1; i < this.dimensionArray.get(currentPattern).length; ++i) {
                            builder.append("," + matcher.group(i + 2));
                        }
                        KeyValPair<MutableDouble, Integer> currentDimensionKeyValPair = currentPatternMap.get(builder.toString());
                        if (currentDimensionKeyValPair == null) continue block0;
                        ((MutableDouble)currentDimensionKeyValPair.getKey()).add(0.0 - tupleValue.get(this.dimensionKeyVal).doubleValue());
                        currentDimensionKeyValPair.setValue((Integer)currentDimensionKeyValPair.getValue() - 1);
                        if (((MutableDouble)currentDimensionKeyValPair.getKey()).doubleValue() != 0.0) continue block0;
                        currentPatternMap.remove(builder.toString());
                        continue block0;
                    }
                    ++currentPattern;
                }
            }
        }
        currentWindowMap.clear();
        if (this.patternList == null || this.patternList.isEmpty()) {
            this.setUpPatternList();
        }
    }

    public void endWindow() {
        int totalWindowsOccupied = this.cacheOject.size();
        for (Map.Entry<String, Map<String, KeyValPair<MutableDouble, Integer>>> e : this.outputMap.entrySet()) {
            for (Map.Entry<String, KeyValPair<MutableDouble, Integer>> dimensionValObj : e.getValue().entrySet()) {
                HashMap<String, DimensionObject<String>> outputData = new HashMap<String, DimensionObject<String>>();
                KeyValPair<MutableDouble, Integer> keyVal = dimensionValObj.getValue();
                if (this.operationType == AggregateOperation.SUM) {
                    outputData.put(e.getKey(), new DimensionObject<String>((MutableDouble)keyVal.getKey(), dimensionValObj.getKey()));
                } else if (this.operationType == AggregateOperation.AVERAGE && (Integer)keyVal.getValue() != 0) {
                    double totalCount = (double)(totalWindowsOccupied * this.applicationWindowSize) / 1000.0;
                    outputData.put(e.getKey(), new DimensionObject<String>(new MutableDouble(((MutableDouble)keyVal.getKey()).doubleValue() / totalCount), dimensionValObj.getKey()));
                }
                if (outputData.isEmpty()) continue;
                this.output.emit(outputData);
            }
        }
        this.currentWindow = (this.currentWindow + 1) % this.windowSize;
    }

    public AggregateOperation getOperationType() {
        return this.operationType;
    }

    public void setOperationType(AggregateOperation operationType) {
        this.operationType = operationType;
    }

    public static enum AggregateOperation {
        SUM,
        AVERAGE;

    }
}

