/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.logs;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.OperatorAnnotation;
import com.datatorrent.api.annotation.Stateless;
import com.datatorrent.common.util.BaseOperator;
import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@OperatorAnnotation(partitionable=true)
public class RegexMatchMapOperator
extends BaseOperator {
    private String regex = null;
    private transient Pattern pattern = null;
    public final transient DefaultInputPort<String> data = new DefaultInputPort<String>(){

        public void process(String s) throws RuntimeException {
            RegexMatchMapOperator.this.processTuple(s);
        }
    };
    public final transient DefaultOutputPort<Map<String, Object>> output = new DefaultOutputPort();
    private static final Logger LOG = LoggerFactory.getLogger(RegexMatchMapOperator.class);

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
        this.pattern = Pattern.compile((String)this.regex);
    }

    public void setup(Context.OperatorContext context) {
        super.setup(context);
        if (this.regex != null) {
            this.pattern = Pattern.compile((String)this.regex);
        }
    }

    public void processTuple(String line) throws RuntimeException {
        if (this.pattern == null) {
            throw new RuntimeException("regex has not been set");
        }
        Matcher matcher = this.pattern.matcher((CharSequence)line);
        if (matcher.matches()) {
            HashMap<String, String> outputMap = new HashMap<String, String>();
            for (String key : this.pattern.groupNames()) {
                outputMap.put(key, matcher.group(key));
            }
            this.output.emit(outputMap);
        }
    }
}

