/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.math;

import com.datatorrent.api.Context;
import com.datatorrent.lib.xml.AbstractXmlDOMOperator;
import com.datatorrent.netlet.util.DTThrowable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlCartesianProduct<T>
extends AbstractXmlDOMOperator<T> {
    @NotNull
    private String config;
    private transient XPath xpath;
    private transient PathElementFactory pathElementFactory;
    private transient CartesianProductFactory cartesianProductFactory;
    private transient CartesianProduct[] cartesianProducts;

    @Override
    protected void processDocument(Document document, T tuple) {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (CartesianProduct cartesianProduct : this.cartesianProducts) {
                cartesianProduct.product(document, result);
            }
            this.processResult(result, tuple);
        }
        catch (XPathExpressionException e) {
            DTThrowable.rethrow((Exception)e);
        }
    }

    protected abstract void processResult(List<String> var1, T var2);

    @Override
    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.xpath = XPathFactory.newInstance().newXPath();
        this.pathElementFactory = new PathElementFactory();
        this.cartesianProductFactory = new CartesianProductFactory();
        this.parseConfig();
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void parseConfig() {
        String[] strprods = this.config.split("\\|");
        this.cartesianProducts = new CartesianProduct[strprods.length];
        for (int i = 0; i < strprods.length; ++i) {
            this.cartesianProducts[i] = this.cartesianProductFactory.getSpecable(strprods[i]);
        }
    }

    private List<Node> getNodes(Document document, String path) throws XPathExpressionException {
        XPathExpression pathExpr = this.xpath.compile(path);
        NodeList nodeList = (NodeList)pathExpr.evaluate(document, XPathConstants.NODESET);
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            nodes.add(nodeList.item(i));
        }
        return nodes;
    }

    protected List<Node> getValueNodes(Node node, String path) throws XPathExpressionException {
        NodeList nodeList = this.getNodes(node, path);
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.getValueNodes(nodeList, nodes);
        return nodes;
    }

    private NodeList getNodes(Node node, String path) throws XPathExpressionException {
        XPathExpression pathExpr = this.xpath.compile(path);
        return (NodeList)pathExpr.evaluate(node, XPathConstants.NODESET);
    }

    protected void getValueNodes(NodeList nodes, List<Node> textNodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (this.isValueNode(node)) {
                textNodes.add(node);
                continue;
            }
            this.getValueNodes(node.getChildNodes(), textNodes);
        }
    }

    public String getValue(List<Node> nodes) {
        StringBuilder sb = new StringBuilder();
        String delim = this.getDelim();
        boolean first = true;
        for (Node node : nodes) {
            if (!first) {
                sb.append(delim);
            } else {
                first = false;
            }
            sb.append(this.getValue(node));
        }
        return sb.toString();
    }

    public String getDelim() {
        return ",";
    }

    public String product(String left, String right) {
        StringBuilder sb = new StringBuilder();
        sb.append(left).append(this.getDelim()).append(right);
        return sb.toString();
    }

    protected abstract boolean isValueNode(Node var1);

    protected abstract String getValue(Node var1);

    private class CartesianProductFactory
    implements SpecableFactory<CartesianProduct> {
        private CartesianProductFactory() {
        }

        @Override
        public CartesianProduct getSpecable(String spec) {
            CartesianProduct product = null;
            product = spec.indexOf("#") == -1 ? new RegularCartesianProduct() : new SelectionCartesianProduct();
            if (product != null) {
                product.parse(spec);
            }
            return product;
        }
    }

    private class PathElementFactory
    implements SpecableFactory<PathElement> {
        private PathElementFactory() {
        }

        @Override
        public PathElement getSpecable(String spec) {
            PathElement pathElement = null;
            pathElement = spec.matches("[^,(]*") ? new SimplePathElement() : new GroupPathElement();
            pathElement.parse(spec);
            return pathElement;
        }
    }

    public class SelectionCartesianProduct
    implements CartesianProduct {
        public SimplePathElement parentElement;
        public PathElement childElement1;
        public PathElement childElement2;

        @Override
        public void parse(String productSpec) {
            int seltnDelIdx = productSpec.indexOf("#");
            if (seltnDelIdx != -1) {
                String parentSpec = productSpec.substring(0, seltnDelIdx);
                PathElement pathElement = AbstractXmlCartesianProduct.this.pathElementFactory.getSpecable(parentSpec);
                if (SimplePathElement.class.isAssignableFrom(pathElement.getClass()) && productSpec.length() > seltnDelIdx + 3) {
                    int chldSepDelIdx;
                    int chldStDelIdx = seltnDelIdx + 1;
                    int chldEdDelIdx = productSpec.length() - 1;
                    if (productSpec.charAt(chldStDelIdx) == '(' && productSpec.charAt(chldEdDelIdx) == ')' && (chldSepDelIdx = productSpec.indexOf(58)) != -1) {
                        String child1Spec = productSpec.substring(chldStDelIdx + 1, chldSepDelIdx);
                        String child2Spec = productSpec.substring(chldSepDelIdx + 1, chldEdDelIdx);
                        this.parentElement = (SimplePathElement)pathElement;
                        this.childElement1 = AbstractXmlCartesianProduct.this.pathElementFactory.getSpecable(child1Spec);
                        this.childElement2 = AbstractXmlCartesianProduct.this.pathElementFactory.getSpecable(child2Spec);
                    }
                }
            }
        }

        @Override
        public void product(Node context, List<String> result) throws XPathExpressionException {
            NodeList nodes = AbstractXmlCartesianProduct.this.getNodes(context, this.parentElement.path);
            for (int i = 0; i < nodes.getLength(); ++i) {
                this.childElement1.productRight(nodes.item(i), this.childElement2, result);
            }
        }
    }

    public class RegularCartesianProduct
    implements CartesianProduct {
        public PathElement element1;
        public PathElement element2;

        @Override
        public void parse(String spec) {
            String[] elements = spec.split("\\:");
            if (elements.length == 2) {
                this.element1 = AbstractXmlCartesianProduct.this.pathElementFactory.getSpecable(elements[0]);
                this.element2 = AbstractXmlCartesianProduct.this.pathElementFactory.getSpecable(elements[1]);
            }
        }

        @Override
        public void product(Node context, List<String> result) throws XPathExpressionException {
            this.element1.productRight(context, this.element2, result);
        }
    }

    private static interface CartesianProduct
    extends Specable {
        @Override
        public void parse(String var1);

        public void product(Node var1, List<String> var2) throws XPathExpressionException;
    }

    public class GroupPathElement
    implements PathElement {
        public boolean unified;
        public PathElement[] pathElements;

        @Override
        public void parse(String spec) {
            int i;
            String estr = spec;
            if (spec.length() >= 2 && spec.charAt(0) == '(') {
                int balance = 1;
                for (i = 1; i < spec.length() && balance > 0; ++i) {
                    if (spec.charAt(i) == ')') {
                        --balance;
                        continue;
                    }
                    if (spec.charAt(i) != '(') continue;
                    ++balance;
                }
                if (i == spec.length()) {
                    estr = spec.substring(1, spec.length() - 1);
                    this.unified = true;
                }
            }
            String[] selements = estr.split(",");
            this.pathElements = new PathElement[selements.length];
            for (i = 0; i < selements.length; ++i) {
                this.pathElements[i] = AbstractXmlCartesianProduct.this.pathElementFactory.getSpecable(selements[i]);
            }
        }

        @Override
        public void productRight(Node context, PathElement pathElement, List<String> result) throws XPathExpressionException {
            if (!this.unified) {
                for (PathElement ePathElement : this.pathElements) {
                    ePathElement.productRight(context, pathElement, result);
                }
            } else {
                List<Node> nodes = this.getValueNodes(context);
                String value = AbstractXmlCartesianProduct.this.getValue(nodes);
                pathElement.productLeft(context, value, result);
            }
        }

        @Override
        public void productLeft(Node context, String value, List<String> result) throws XPathExpressionException {
            if (!this.unified) {
                for (PathElement pathElement : this.pathElements) {
                    pathElement.productLeft(context, value, result);
                }
            } else {
                List<Node> nodes = this.getValueNodes(context);
                String evalue = AbstractXmlCartesianProduct.this.getValue(nodes);
                String product = AbstractXmlCartesianProduct.this.product(value, evalue);
                result.add(product);
            }
        }

        @Override
        public List<Node> getValueNodes(Node context) throws XPathExpressionException {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (PathElement pathElement : this.pathElements) {
                nodes.addAll(pathElement.getValueNodes(context));
            }
            return nodes;
        }
    }

    public class SimplePathElement
    implements PathElement {
        public String path;

        @Override
        public void parse(String spec) {
            this.path = spec;
        }

        @Override
        public void productRight(Node context, PathElement pathElement, List<String> result) throws XPathExpressionException {
            List<Node> nodes = AbstractXmlCartesianProduct.this.getValueNodes(context, this.path);
            for (Node node : nodes) {
                String value = AbstractXmlCartesianProduct.this.getValue(node);
                pathElement.productLeft(context, value, result);
            }
        }

        @Override
        public void productLeft(Node context, String left, List<String> result) throws XPathExpressionException {
            List<Node> nodes = AbstractXmlCartesianProduct.this.getValueNodes(context, this.path);
            for (Node node : nodes) {
                String value = AbstractXmlCartesianProduct.this.getValue(node);
                String product = AbstractXmlCartesianProduct.this.product(left, value);
                result.add(product);
            }
        }

        @Override
        public List<Node> getValueNodes(Node context) throws XPathExpressionException {
            return AbstractXmlCartesianProduct.this.getValueNodes(context, this.path);
        }
    }

    public static interface PathElement
    extends Specable {
        public void productRight(Node var1, PathElement var2, List<String> var3) throws XPathExpressionException;

        public void productLeft(Node var1, String var2, List<String> var3) throws XPathExpressionException;

        public List<Node> getValueNodes(Node var1) throws XPathExpressionException;
    }

    private static interface SpecableFactory<T> {
        public T getSpecable(String var1);
    }

    private static interface Specable {
        public void parse(String var1);
    }
}

