/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.math;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.lib.util.BaseNumberValueOperator;

public class Average<V extends Number>
extends BaseNumberValueOperator<V> {
    public final transient DefaultInputPort<V> data = new DefaultInputPort<V>(){

        public void process(V tuple) {
            Average.this.sums += ((Number)tuple).doubleValue();
            ++Average.this.counts;
        }
    };
    public final transient DefaultOutputPort<V> average = new DefaultOutputPort();
    protected double sums = 0.0;
    protected long counts = 0L;

    public void endWindow() {
        if (this.counts != 0L) {
            this.average.emit(this.getAverage());
        }
        this.sums = 0.0;
        this.counts = 0L;
    }

    public V getAverage() {
        Number val;
        if (this.counts == 0L) {
            return null;
        }
        Object num = this.getValue(this.sums);
        switch (this.getType()) {
            case DOUBLE: {
                val = new Double(((Number)num).doubleValue() / (double)this.counts);
                break;
            }
            case INTEGER: {
                int icount = (int)((long)((Number)num).intValue() / this.counts);
                val = new Integer(icount);
                break;
            }
            case FLOAT: {
                val = new Float(((Number)num).floatValue() / (float)this.counts);
                break;
            }
            case LONG: {
                val = new Long(((Number)num).longValue() / this.counts);
                break;
            }
            case SHORT: {
                short scount = (short)((long)((Number)num).shortValue() / this.counts);
                val = new Short(scount);
                break;
            }
            default: {
                val = new Double(((Number)num).doubleValue() / (double)this.counts);
            }
        }
        return (V)val;
    }
}

