/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.math;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.lib.util.BaseNumberValueOperator;
import com.datatorrent.lib.util.KeyValPair;
import javax.validation.constraints.Min;

public class ChangeAlert<V extends Number>
extends BaseNumberValueOperator<V> {
    public final transient DefaultInputPort<V> data = new DefaultInputPort<V>(){

        public void process(V tuple) {
            double tval = ((Number)tuple).doubleValue();
            if (ChangeAlert.this.baseValue == 0.0) {
                ChangeAlert.this.baseValue = tval;
                return;
            }
            double change = tval - ChangeAlert.this.baseValue;
            double percent = change / ChangeAlert.this.baseValue * 100.0;
            if (percent < 0.0) {
                percent = 0.0 - percent;
            }
            if (percent > ChangeAlert.this.percentThreshold) {
                KeyValPair kv = new KeyValPair(ChangeAlert.this.cloneKey(tuple), percent);
                ChangeAlert.this.alert.emit(kv);
            }
            ChangeAlert.this.baseValue = tval;
        }
    };
    public final transient DefaultOutputPort<KeyValPair<V, Double>> alert = new DefaultOutputPort();
    private double baseValue = 0.0;
    @Min(value=1L)
    private double percentThreshold = 0.0;

    @Min(value=1L)
    public double getPercentThreshold() {
        return this.percentThreshold;
    }

    public void setPercentThreshold(double d) {
        this.percentThreshold = d;
    }
}

