/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.math;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.lib.util.BaseNumberKeyValueOperator;
import com.datatorrent.lib.util.KeyValPair;
import java.util.HashMap;
import javax.validation.constraints.Min;
import org.apache.commons.lang.mutable.MutableDouble;

public class ChangeAlertKeyVal<K, V extends Number>
extends BaseNumberKeyValueOperator<K, V> {
    private HashMap<K, MutableDouble> basemap = new HashMap();
    public final transient DefaultInputPort<KeyValPair<K, V>> data = new DefaultInputPort<KeyValPair<K, V>>(){

        public void process(KeyValPair<K, V> tuple) {
            Object key = tuple.getKey();
            double tval = ((Number)tuple.getValue()).doubleValue();
            MutableDouble val = (MutableDouble)ChangeAlertKeyVal.this.basemap.get(key);
            if (!ChangeAlertKeyVal.this.doprocessKey(key)) {
                return;
            }
            if (val == null) {
                val = new MutableDouble(tval);
                ChangeAlertKeyVal.this.basemap.put(ChangeAlertKeyVal.this.cloneKey(key), val);
                return;
            }
            double change = tval - val.doubleValue();
            double percent = change / val.doubleValue() * 100.0;
            if (percent < 0.0) {
                percent = 0.0 - percent;
            }
            if (percent > ChangeAlertKeyVal.this.percentThreshold) {
                KeyValPair dmap = new KeyValPair(ChangeAlertKeyVal.this.cloneValue(tuple.getValue()), percent);
                KeyValPair otuple = new KeyValPair(ChangeAlertKeyVal.this.cloneKey(key), dmap);
                ChangeAlertKeyVal.this.alert.emit(otuple);
            }
            val.setValue(tval);
        }
    };
    public final transient DefaultOutputPort<KeyValPair<K, KeyValPair<V, Double>>> alert = new DefaultOutputPort();
    @Min(value=1L)
    private double percentThreshold = 0.0;

    @Min(value=1L)
    public double getPercentThreshold() {
        return this.percentThreshold;
    }

    public void setPercentThreshold(double d) {
        this.percentThreshold = d;
    }
}

