/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.math;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.common.util.BaseOperator;
import java.util.ArrayList;

public class Division
extends BaseOperator {
    private ArrayList<Number> numer = new ArrayList();
    private ArrayList<Number> denom = new ArrayList();
    private int index = 0;
    public final transient DefaultInputPort<Number> numerator = new DefaultInputPort<Number>(){

        public void process(Number tuple) {
            Division.this.numer.add(tuple);
            if (Division.this.denom.size() > Division.this.index) {
                int loc = Division.this.denom.size();
                if (loc > Division.this.numer.size()) {
                    loc = Division.this.numer.size();
                }
                Division.this.emit((Number)Division.this.numer.get(loc - 1), (Number)Division.this.denom.get(loc - 1));
                Division.this.index++;
            }
        }
    };
    public final transient DefaultInputPort<Number> denominator = new DefaultInputPort<Number>(){

        public void process(Number tuple) {
            if (tuple.doubleValue() == 0.0) {
                Division.this.errordata.emit((Object)"Error(0.0)");
                return;
            }
            Division.this.denom.add(tuple);
            if (Division.this.numer.size() > Division.this.index) {
                int loc = Division.this.denom.size();
                if (loc > Division.this.numer.size()) {
                    loc = Division.this.numer.size();
                }
                Division.this.emit((Number)Division.this.numer.get(loc - 1), (Number)Division.this.denom.get(loc - 1));
                Division.this.index++;
            }
        }
    };
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<Long> longQuotient = new DefaultOutputPort();
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<Integer> integerQuotient = new DefaultOutputPort();
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<Double> doubleQuotient = new DefaultOutputPort();
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<Float> floatQuotient = new DefaultOutputPort();
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<Long> longRemainder = new DefaultOutputPort();
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<Integer> integerRemainder = new DefaultOutputPort();
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<Double> doubleRemainder = new DefaultOutputPort();
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<Float> floatRemainder = new DefaultOutputPort();
    @OutputPortFieldAnnotation(error=true)
    public final transient DefaultOutputPort<String> errordata = new DefaultOutputPort();

    public void emit(Number numer, Number denom) {
        Long lQuotient = null;
        Double dQuotient = null;
        Long lRemainder = null;
        Double dRemainder = null;
        if (this.longQuotient.isConnected()) {
            lQuotient = numer.longValue() / denom.longValue();
            this.longQuotient.emit((Object)lQuotient);
        }
        if (this.longRemainder.isConnected()) {
            lRemainder = numer.longValue() % denom.longValue();
            this.longRemainder.emit((Object)lRemainder);
        }
        if (this.integerQuotient.isConnected()) {
            this.integerQuotient.emit((Object)(lQuotient == null ? (int)(numer.longValue() % denom.longValue()) : lQuotient.intValue()));
        }
        if (this.integerRemainder.isConnected()) {
            this.integerRemainder.emit((Object)(lRemainder == null ? (int)(numer.longValue() % denom.longValue()) : lRemainder.intValue()));
        }
        if (this.doubleQuotient.isConnected()) {
            dQuotient = numer.doubleValue() / denom.doubleValue();
            this.doubleQuotient.emit((Object)dQuotient);
        }
        if (this.doubleRemainder.isConnected()) {
            dRemainder = numer.doubleValue() % denom.doubleValue();
            this.doubleRemainder.emit((Object)dRemainder);
        }
        if (this.floatQuotient.isConnected()) {
            this.floatQuotient.emit((Object)Float.valueOf(dQuotient == null ? (float)(numer.doubleValue() / denom.doubleValue()) : dQuotient.floatValue()));
        }
        if (this.floatRemainder.isConnected()) {
            this.floatRemainder.emit((Object)Float.valueOf(dRemainder == null ? (float)(numer.doubleValue() % denom.doubleValue()) : dRemainder.floatValue()));
        }
    }

    public void endWindow() {
        this.numer.clear();
        this.denom.clear();
        this.index = 0;
    }
}

