/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.math;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.OperatorAnnotation;
import com.datatorrent.lib.util.BaseNumberValueOperator;

@OperatorAnnotation(partitionable=false)
public class Margin<V extends Number>
extends BaseNumberValueOperator<V> {
    protected double nval = 0.0;
    protected double dval = 0.0;
    protected boolean percent = false;
    public final transient DefaultInputPort<V> numerator = new DefaultInputPort<V>(){

        public void process(V tuple) {
            Margin.this.nval += ((Number)tuple).doubleValue();
        }
    };
    public final transient DefaultInputPort<V> denominator = new DefaultInputPort<V>(){

        public void process(V tuple) {
            Margin.this.dval += ((Number)tuple).doubleValue();
        }
    };
    public final transient DefaultOutputPort<V> margin = new DefaultOutputPort();

    public boolean getPercent() {
        return this.percent;
    }

    public void setPercent(boolean val) {
        this.percent = val;
    }

    public void endWindow() {
        if (this.dval == 0.0) {
            return;
        }
        double val = 1.0 - this.nval / this.dval;
        if (this.percent) {
            val *= 100.0;
        }
        this.margin.emit(this.getValue(val));
        this.nval = 0.0;
        this.dval = 0.0;
    }
}

