/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.math;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.lib.util.BaseNumberKeyValueOperator;
import com.datatorrent.lib.util.UnifierHashMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableDouble;

public class MarginMap<K, V extends Number>
extends BaseNumberKeyValueOperator<K, V> {
    public final transient DefaultInputPort<Map<K, V>> numerator = new DefaultInputPort<Map<K, V>>(){

        public void process(Map<K, V> tuple) {
            MarginMap.this.addTuple(tuple, MarginMap.this.numerators);
        }
    };
    public final transient DefaultInputPort<Map<K, V>> denominator = new DefaultInputPort<Map<K, V>>(){

        public void process(Map<K, V> tuple) {
            MarginMap.this.addTuple(tuple, MarginMap.this.denominators);
        }
    };
    public final transient DefaultOutputPort<HashMap<K, V>> margin = new DefaultOutputPort<HashMap<K, V>>(){

        public Operator.Unifier<HashMap<K, V>> getUnifier() {
            return new UnifierHashMap();
        }
    };
    protected HashMap<K, MutableDouble> numerators = new HashMap();
    protected HashMap<K, MutableDouble> denominators = new HashMap();
    boolean percent = false;

    public void addTuple(Map<K, V> tuple, Map<K, MutableDouble> map) {
        for (Map.Entry<K, V> e : tuple.entrySet()) {
            if (!this.doprocessKey(e.getKey()) || e.getValue() == null) continue;
            MutableDouble val = map.get(e.getKey());
            if (val == null) {
                val = new MutableDouble(0.0);
                map.put(this.cloneKey(e.getKey()), val);
            }
            val.add(((Number)e.getValue()).doubleValue());
        }
    }

    public boolean getPercent() {
        return this.percent;
    }

    public void setPercent(boolean val) {
        this.percent = val;
    }

    public void endWindow() {
        HashMap tuples = new HashMap();
        for (Map.Entry<K, MutableDouble> e : this.denominators.entrySet()) {
            MutableDouble nval = this.numerators.get(e.getKey());
            if (nval == null) {
                nval = new MutableDouble(0.0);
            } else {
                this.numerators.remove(e.getKey());
            }
            Double val = this.percent ? Double.valueOf((1.0 - nval.doubleValue() / e.getValue().doubleValue()) * 100.0) : Double.valueOf(1.0 - nval.doubleValue() / e.getValue().doubleValue());
            tuples.put(e.getKey(), this.getValue((double)val));
        }
        if (!tuples.isEmpty()) {
            this.margin.emit(tuples);
        }
        this.numerators.clear();
        this.denominators.clear();
    }
}

