/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.math;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.OperatorAnnotation;
import com.datatorrent.common.util.BaseOperator;

@OperatorAnnotation(partitionable=false)
public class RunningAverage
extends BaseOperator {
    double average;
    long count;
    public final transient DefaultInputPort<Number> input = new DefaultInputPort<Number>(){

        public void process(Number tuple) {
            double sum = (double)RunningAverage.this.count * RunningAverage.this.average + tuple.doubleValue();
            ++RunningAverage.this.count;
            RunningAverage.this.average = sum / (double)RunningAverage.this.count;
        }
    };
    public final transient DefaultOutputPort<Double> doubleAverage = new DefaultOutputPort();
    public final transient DefaultOutputPort<Float> floatAverage = new DefaultOutputPort();
    public final transient DefaultOutputPort<Long> longAverage = new DefaultOutputPort();
    public final transient DefaultOutputPort<Integer> integerAverage = new DefaultOutputPort();

    public void endWindow() {
        if (this.doubleAverage.isConnected()) {
            this.doubleAverage.emit((Object)this.average);
        }
        if (this.floatAverage.isConnected()) {
            this.floatAverage.emit((Object)Float.valueOf((float)this.average));
        }
        if (this.longAverage.isConnected()) {
            this.longAverage.emit((Object)((long)this.average));
        }
        if (this.integerAverage.isConnected()) {
            this.integerAverage.emit((Object)((int)this.average));
        }
    }
}

