/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.math;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.lib.util.BaseNumberValueOperator;
import com.datatorrent.lib.util.UnifierSumNumber;
import java.util.HashMap;
import java.util.Map;

public class Sum<V extends Number>
extends BaseNumberValueOperator<V>
implements Operator.Unifier<V> {
    protected double sums = 0.0;
    protected boolean tupleAvailable = false;
    protected boolean cumulative = false;
    public final transient DefaultInputPort<V> data = new DefaultInputPort<V>(){

        public void process(V tuple) {
            Sum.this.process(tuple);
            Sum.this.tupleAvailable = true;
        }
    };
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<V> sum = new DefaultOutputPort<V>(){

        public Operator.Unifier<V> getUnifier() {
            UnifierSumNumber ret = new UnifierSumNumber();
            ret.setVType(Sum.this.getType());
            return ret;
        }
    };
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<Double> sumDouble = new DefaultOutputPort<Double>(){

        public Operator.Unifier<Double> getUnifier() {
            UnifierSumNumber<Double> ret = new UnifierSumNumber<Double>();
            ret.setType(Double.class);
            return ret;
        }
    };
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<Integer> sumInteger = new DefaultOutputPort<Integer>(){

        public Operator.Unifier<Integer> getUnifier() {
            UnifierSumNumber<Integer> ret = new UnifierSumNumber<Integer>();
            ret.setType(Integer.class);
            return ret;
        }
    };
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<Long> sumLong = new DefaultOutputPort<Long>(){

        public Operator.Unifier<Long> getUnifier() {
            UnifierSumNumber<Long> ret = new UnifierSumNumber<Long>();
            ret.setType(Long.class);
            return ret;
        }
    };
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<Short> sumShort = new DefaultOutputPort<Short>(){

        public Operator.Unifier<Short> getUnifier() {
            UnifierSumNumber<Short> ret = new UnifierSumNumber<Short>();
            ret.setType(Short.class);
            return ret;
        }
    };
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<Float> sumFloat = new DefaultOutputPort<Float>(){

        public Operator.Unifier<Float> getUnifier() {
            UnifierSumNumber<Float> ret = new UnifierSumNumber<Float>();
            ret.setType(Float.class);
            return ret;
        }
    };
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<Map<Integer, Integer>> redisport = new DefaultOutputPort();

    public void process(V tuple) {
        this.sums += ((Number)tuple).doubleValue();
        this.tupleAvailable = true;
    }

    public boolean isCumulative() {
        return this.cumulative;
    }

    public void setCumulative(boolean cumulative) {
        this.cumulative = cumulative;
    }

    public void endWindow() {
        if (this.doEmit()) {
            this.sum.emit(this.getValue(this.sums));
            this.sumDouble.emit((Object)this.sums);
            this.sumInteger.emit((Object)((int)this.sums));
            this.sumLong.emit((Object)((long)this.sums));
            this.sumShort.emit((Object)((short)this.sums));
            this.sumFloat.emit((Object)Float.valueOf((float)this.sums));
            this.tupleAvailable = false;
            HashMap<Integer, Integer> redis = new HashMap<Integer, Integer>();
            redis.put(1, (int)this.sums);
            this.redisport.emit(redis);
        }
        this.clearCache();
    }

    private void clearCache() {
        if (!this.cumulative) {
            this.sums = 0.0;
        }
    }

    private boolean doEmit() {
        return this.tupleAvailable;
    }
}

