/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.multiwindow;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.common.util.BaseOperator;
import java.util.ArrayList;
import javax.validation.constraints.Min;

public abstract class AbstractSlidingWindow<T, S>
extends BaseOperator {
    public final transient DefaultInputPort<T> data = new DefaultInputPort<T>(){

        public void process(T tuple) {
            AbstractSlidingWindow.this.processDataTuple(tuple);
        }
    };
    protected ArrayList<S> states = null;
    protected S lastExpiredWindowState = null;
    protected int currentCursor = -1;
    @Min(value=2L)
    int windowSize = 2;

    @Min(value=2L)
    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    protected abstract void processDataTuple(T var1);

    public abstract S createWindowState();

    public S getStreamingWindowState(int i) {
        if (i == -1) {
            return this.lastExpiredWindowState;
        }
        if (i >= this.getWindowSize()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int index = (this.currentCursor + 1 + i) % this.windowSize;
        return this.states.get(index);
    }

    public void beginWindow(long windowId) {
        this.currentCursor = (this.currentCursor + 1) % this.windowSize;
        this.lastExpiredWindowState = this.states.get(this.currentCursor);
        this.states.set(this.currentCursor, this.createWindowState());
    }

    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.states = new ArrayList(this.windowSize);
        for (int i = 0; i < this.windowSize; ++i) {
            this.states.add(null);
        }
        this.currentCursor = -1;
    }
}

