/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.multiwindow;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.lib.multiwindow.SimpleMovingAverageObject;
import com.datatorrent.lib.util.BaseNumberKeyValueOperator;
import com.datatorrent.lib.util.KeyValPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.Min;

public abstract class AbstractSlidingWindowKeyVal<K, V extends Number, S extends SimpleMovingAverageObject>
extends BaseNumberKeyValueOperator<K, V> {
    protected HashMap<K, ArrayList<S>> buffer = new HashMap();
    protected int currentstate = -1;
    @Min(value=2L)
    protected int windowSize = 2;
    protected long windowId;
    public final transient DefaultInputPort<KeyValPair<K, V>> data = new DefaultInputPort<KeyValPair<K, V>>(){

        public void process(KeyValPair<K, V> tuple) {
            AbstractSlidingWindowKeyVal.this.processDataTuple(tuple);
        }
    };

    public abstract void processDataTuple(KeyValPair<K, V> var1);

    public abstract void emitTuple(K var1, ArrayList<S> var2);

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public void beginWindow(long windowId) {
        this.windowId = windowId;
        ++this.currentstate;
        if (this.currentstate >= this.windowSize) {
            for (Map.Entry<K, ArrayList<S>> e : this.buffer.entrySet()) {
                ArrayList<S> states = e.getValue();
                SimpleMovingAverageObject first = (SimpleMovingAverageObject)states.get(0);
                for (int i = 1; i < this.windowSize; ++i) {
                    states.set(i - 1, states.get(i));
                }
                states.set(this.windowSize - 1, first);
            }
            this.currentstate = this.windowSize - 1;
        }
        for (Map.Entry<K, ArrayList<S>> e : this.buffer.entrySet()) {
            ((SimpleMovingAverageObject)e.getValue().get(this.currentstate)).clear();
        }
    }

    public void endWindow() {
        for (Map.Entry<K, ArrayList<S>> e : this.buffer.entrySet()) {
            this.emitTuple(e.getKey(), e.getValue());
        }
    }
}

