/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.multiwindow;

import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.OperatorAnnotation;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.lib.multiwindow.AbstractSlidingWindowKeyVal;
import com.datatorrent.lib.multiwindow.SimpleMovingAverageObject;
import com.datatorrent.lib.util.KeyValPair;
import java.util.ArrayList;

@OperatorAnnotation(partitionable=false)
public class SimpleMovingAverage<K, V extends Number>
extends AbstractSlidingWindowKeyVal<K, V, SimpleMovingAverageObject> {
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<KeyValPair<K, Double>> doubleSMA = new DefaultOutputPort();
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<KeyValPair<K, Float>> floatSMA = new DefaultOutputPort();
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<KeyValPair<K, Long>> longSMA = new DefaultOutputPort();
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<KeyValPair<K, Integer>> integerSMA = new DefaultOutputPort();

    @Override
    public void processDataTuple(KeyValPair<K, V> tuple) {
        Object key = tuple.getKey();
        double val = ((Number)tuple.getValue()).doubleValue();
        ArrayList<SimpleMovingAverageObject> dataList = (ArrayList<SimpleMovingAverageObject>)this.buffer.get(key);
        if (dataList == null) {
            dataList = new ArrayList<SimpleMovingAverageObject>(this.windowSize);
            for (int i = 0; i < this.windowSize; ++i) {
                dataList.add(new SimpleMovingAverageObject());
            }
        }
        ((SimpleMovingAverageObject)dataList.get(this.currentstate)).add(val);
        this.buffer.put(key, dataList);
    }

    @Override
    public void emitTuple(K key, ArrayList<SimpleMovingAverageObject> obj) {
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < this.windowSize; ++i) {
            SimpleMovingAverageObject d = obj.get(i);
            sum += d.getSum();
            count += d.getCount();
        }
        if (count == 0) {
            return;
        }
        if (this.doubleSMA.isConnected()) {
            this.doubleSMA.emit(new KeyValPair<K, Double>(key, sum / (double)count));
        }
        if (this.floatSMA.isConnected()) {
            this.floatSMA.emit(new KeyValPair<K, Float>(key, Float.valueOf((float)(sum / (double)count))));
        }
        if (this.longSMA.isConnected()) {
            this.longSMA.emit(new KeyValPair<K, Long>(key, (long)(sum / (double)count)));
        }
        if (this.integerSMA.isConnected()) {
            this.integerSMA.emit(new KeyValPair<K, Integer>(key, (int)(sum / (double)count)));
        }
    }
}

