/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.multiwindow;

import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.lib.multiwindow.AbstractSlidingWindow;
import com.google.common.base.Function;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.ClassUtils;

public class SortedMovingWindow<T, K>
extends AbstractSlidingWindow<T, List<T>> {
    public transient DefaultOutputPort<T> outputPort = new DefaultOutputPort();
    @OutputPortFieldAnnotation(error=true)
    public transient DefaultOutputPort<T> errorOutput = new DefaultOutputPort();
    private Map<K, PriorityQueue<T>> sortedListInSlidingWin = new HashMap<K, PriorityQueue<T>>();
    private List<T> tuplesInCurrentStreamWindow = new LinkedList<T>();
    @NotNull
    private Function<T, K> function = new SingleKeyMappingFunction();
    private Comparator<T> comparator = null;

    @Override
    protected void processDataTuple(T tuple) {
        this.tuplesInCurrentStreamWindow.add(tuple);
        Object key = this.function.apply(tuple);
        PriorityQueue<T> sortedList = this.sortedListInSlidingWin.get(key);
        if (sortedList == null) {
            sortedList = new PriorityQueue<T>(10, this.comparator);
            this.sortedListInSlidingWin.put(key, sortedList);
        }
        sortedList.add(tuple);
    }

    @Override
    public List<T> createWindowState() {
        return this.tuplesInCurrentStreamWindow;
    }

    /*
     * Unable to fully structure code
     */
    public void endWindow() {
        super.endWindow();
        this.tuplesInCurrentStreamWindow = new LinkedList<T>();
        if (this.lastExpiredWindowState == null) {
            return;
        }
        block0: for (E expiredTuple : (List)this.lastExpiredWindowState) {
            sortedListForE = this.sortedListInSlidingWin.get(this.function.apply(expiredTuple));
            iterator = sortedListForE.iterator();
            while (iterator.hasNext()) {
                minElemInSortedList = iterator.next();
                k = 0;
                if (this.comparator != null) ** GOTO lbl17
                if (expiredTuple instanceof Comparable) {
                    k = ((Comparable)expiredTuple).compareTo(minElemInSortedList);
                } else {
                    this.errorOutput.emit(expiredTuple);
                    throw new IllegalArgumentException("Operator \"" + ClassUtils.getShortClassName(this.getClass()) + "\" encounters an invalid tuple " + expiredTuple + "\nNeither the tuple is comparable Nor Comparator is specified!");
lbl17:
                    // 1 sources

                    k = this.comparator.compare(expiredTuple, minElemInSortedList);
                }
                if (k < 0) continue block0;
                this.outputPort.emit(minElemInSortedList);
                iterator.remove();
            }
        }
    }

    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public void setFunction(Function<T, K> function) {
        this.function = function;
    }

    private static class SingleKeyMappingFunction<T, K>
    implements Function<T, K> {
        private SingleKeyMappingFunction() {
        }

        public K apply(T input) {
            return null;
        }
    }
}

