/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.parser;

import com.datatorrent.api.AutoMetric;
import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.lib.converter.Converter;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Evolving
public abstract class Parser<INPUT, ERROROUT>
extends BaseOperator
implements Converter<INPUT, Object> {
    protected transient Class<?> clazz;
    @AutoMetric
    protected long errorTupleCount;
    @AutoMetric
    protected long emittedObjectCount;
    @AutoMetric
    protected long incomingTuplesCount;
    @OutputPortFieldAnnotation(schemaRequired=true)
    public transient DefaultOutputPort<Object> out = new DefaultOutputPort<Object>(){

        public void setup(Context.PortContext context) {
            Parser.this.clazz = (Class)context.getValue(Context.PortContext.TUPLE_CLASS);
        }
    };
    public transient DefaultOutputPort<ERROROUT> err = new DefaultOutputPort();
    public transient DefaultInputPort<INPUT> in = new DefaultInputPort<INPUT>(){

        public void process(INPUT inputTuple) {
            ++Parser.this.incomingTuplesCount;
            Parser.this.processTuple(inputTuple);
        }
    };

    public void processTuple(INPUT inputTuple) {
        Object tuple = this.convert(inputTuple);
        if (tuple == null && this.err.isConnected()) {
            ++this.errorTupleCount;
            this.err.emit(this.processErrorTuple(inputTuple));
            return;
        }
        if (this.out.isConnected()) {
            ++this.emittedObjectCount;
            this.out.emit(tuple);
        }
    }

    public abstract ERROROUT processErrorTuple(INPUT var1);

    public void beginWindow(long windowId) {
        this.errorTupleCount = 0L;
        this.emittedObjectCount = 0L;
        this.incomingTuplesCount = 0L;
    }

    public void endWindow() {
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }
}

