/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.parser;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.lib.parser.Parser;
import com.datatorrent.lib.util.ReusableStringReader;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@InterfaceStability.Evolving
public class XmlParser
extends Parser<String, String> {
    private String schemaXSDFile;
    private transient Unmarshaller unmarshaller;
    private transient Validator validator;
    private ReusableStringReader reader = new ReusableStringReader();
    public transient DefaultOutputPort<Document> parsedOutput = new DefaultOutputPort();
    public static Logger LOG = LoggerFactory.getLogger(Parser.class);

    @Override
    public Object convert(String tuple) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processTuple(String inputTuple) {
        try {
            if (this.out.isConnected()) {
                this.reader.open(inputTuple);
                JAXBElement output = this.unmarshaller.unmarshal((Source)new StreamSource(this.reader), this.getClazz());
                LOG.debug(output.getValue().toString());
                ++this.emittedObjectCount;
                this.out.emit(output.getValue());
            } else if (this.validator != null) {
                this.validator.validate(new StreamSource(inputTuple));
            }
            if (this.parsedOutput.isConnected()) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(inputTuple);
                    this.parsedOutput.emit((Object)doc);
                }
                catch (Exception e) {
                    LOG.info("Failed to parse xml tuple {}, Exception = {} , StackTrace = {}", new Object[]{inputTuple, e, e.getStackTrace()});
                    ++this.errorTupleCount;
                    if (this.err.isConnected()) {
                        this.err.emit((Object)inputTuple);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.info("Failed to parse xml tuple {}, Exception = {}, StackTrace = {} ", new Object[]{inputTuple, e, e.getStackTrace()});
            ++this.errorTupleCount;
            if (this.err.isConnected()) {
                this.err.emit((Object)inputTuple);
            }
        }
        finally {
            try {
                if (this.reader.isOpen()) {
                    this.reader.close();
                }
            }
            catch (IOException e) {
                DTThrowable.wrapIfChecked((Exception)e);
            }
        }
    }

    @Override
    public String processErrorTuple(String input) {
        return input;
    }

    public void setup(Context.OperatorContext context) {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{this.getClazz()});
            this.unmarshaller = ctx.createUnmarshaller();
            if (this.schemaXSDFile != null) {
                Path filePath = new Path(this.schemaXSDFile);
                Configuration configuration = new Configuration();
                FileSystem fs = FileSystem.newInstance((URI)filePath.toUri(), (Configuration)configuration);
                FSDataInputStream inputStream = fs.open(filePath);
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = factory.newSchema(new StreamSource((InputStream)inputStream));
                this.unmarshaller.setSchema(schema);
                this.validator = schema.newValidator();
                fs.close();
            }
        }
        catch (SAXException e) {
            DTThrowable.wrapIfChecked((Exception)e);
        }
        catch (JAXBException e) {
            DTThrowable.wrapIfChecked((Exception)((Object)e));
        }
        catch (IOException e) {
            DTThrowable.wrapIfChecked((Exception)e);
        }
    }

    public String getSchemaFile() {
        return this.schemaXSDFile;
    }

    public void setSchemaFile(String schemaFile) {
        this.schemaXSDFile = schemaFile;
    }
}

