/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.projection;

import com.datatorrent.api.AutoMetric;
import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.api.annotation.InputPortFieldAnnotation;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.lib.util.PojoUtils;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectionOperator
extends BaseOperator
implements Operator.ActivationListener<Context> {
    protected String selectFields;
    protected String dropFields;
    protected String condition;
    private transient List<TypeInfo> projectedFields = new ArrayList<TypeInfo>();
    private transient List<TypeInfo> remainderFields = new ArrayList<TypeInfo>();
    @AutoMetric
    protected long projectedTuples;
    @AutoMetric
    protected long remainderTuples;
    @AutoMetric
    protected long errorTuples;
    protected Class<?> inClazz = null;
    protected Class<?> projectedClazz = null;
    protected Class<?> remainderClazz = null;
    @InputPortFieldAnnotation(schemaRequired=true)
    public transient DefaultInputPort<Object> input = new DefaultInputPort<Object>(){

        public void setup(Context.PortContext context) {
            ProjectionOperator.this.inClazz = (Class)context.getValue(Context.PortContext.TUPLE_CLASS);
        }

        public void process(Object t) {
            ProjectionOperator.this.handleProjection(t);
        }
    };
    @OutputPortFieldAnnotation(schemaRequired=true)
    public final transient DefaultOutputPort<Object> projected = new DefaultOutputPort<Object>(){

        public void setup(Context.PortContext context) {
            ProjectionOperator.this.projectedClazz = (Class)context.getValue(Context.PortContext.TUPLE_CLASS);
        }
    };
    @OutputPortFieldAnnotation(schemaRequired=true)
    public final transient DefaultOutputPort<Object> remainder = new DefaultOutputPort<Object>(){

        public void setup(Context.PortContext context) {
            ProjectionOperator.this.remainderClazz = (Class)context.getValue(Context.PortContext.TUPLE_CLASS);
        }
    };
    public final transient DefaultOutputPort<Object> error = new DefaultOutputPort();
    private static final Logger logger = LoggerFactory.getLogger(ProjectionOperator.class);

    @VisibleForTesting
    List<TypeInfo> getProjectedFields() {
        return this.projectedFields;
    }

    @VisibleForTesting
    List<TypeInfo> getRemainderFields() {
        return this.remainderFields;
    }

    protected void addProjectedField(String s) {
        try {
            Field f = this.inClazz.getDeclaredField(s);
            TypeInfo t = new TypeInfo(f.getName(), ClassUtils.primitiveToWrapper(f.getType()));
            t.getter = PojoUtils.createGetter(this.inClazz, t.name, t.type);
            t.setter = PojoUtils.createSetter(this.projectedClazz, t.name, t.type);
            this.projectedFields.add(t);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Field " + s + " not found in class " + this.inClazz, e);
        }
    }

    protected void addRemainderField(String s) {
        try {
            Field f = this.inClazz.getDeclaredField(s);
            TypeInfo t = new TypeInfo(f.getName(), ClassUtils.primitiveToWrapper(f.getType()));
            t.getter = PojoUtils.createGetter(this.inClazz, t.name, t.type);
            t.setter = PojoUtils.createSetter(this.remainderClazz, t.name, t.type);
            this.remainderFields.add(t);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Field " + s + " not found in class " + this.inClazz, e);
        }
    }

    public void activate(Context context) {
        Field[] allFields = this.inClazz.getDeclaredFields();
        if (this.selectFields != null && !this.selectFields.isEmpty()) {
            List<String> sFields = Arrays.asList(this.selectFields.split(","));
            for (String string : sFields) {
                this.addProjectedField(string);
            }
            if (this.remainderClazz != null) {
                for (Field f : allFields) {
                    if (sFields.contains(f.getName())) continue;
                    this.addRemainderField(f.getName());
                }
            } else {
                logger.info("Remainder Port does not have Schema class defined");
            }
        } else {
            List<Object> dFields = new ArrayList();
            if (this.dropFields != null && !this.dropFields.isEmpty()) {
                dFields = Arrays.asList(this.dropFields.split(","));
                if (this.remainderClazz != null) {
                    for (String string : dFields) {
                        this.addRemainderField(string);
                    }
                } else {
                    logger.info("Remainder Port does not have Schema class defined");
                }
            }
            for (Field f : allFields) {
                if (dFields.contains(f.getName())) continue;
                this.addProjectedField(f.getName());
            }
        }
        logger.debug("projected fields: {}", this.projectedFields);
        logger.debug("remainder fields: {}", this.remainderFields);
    }

    public void deactivate() {
        this.projectedFields.clear();
        this.remainderFields.clear();
    }

    public void beginWindow(long windowId) {
        this.remainderTuples = 0L;
        this.projectedTuples = 0L;
        this.errorTuples = 0L;
    }

    protected Object getProjectedObject(Object t) throws IllegalAccessException {
        try {
            Object p = this.projectedClazz.newInstance();
            for (TypeInfo ti : this.projectedFields) {
                ti.setter.set(p, ti.getter.get(t));
            }
            return p;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw e;
        }
    }

    protected Object getRemainderObject(Object t) throws IllegalAccessException {
        try {
            Object r = this.remainderClazz.newInstance();
            for (TypeInfo ti : this.remainderFields) {
                ti.setter.set(r, ti.getter.get(t));
            }
            return r;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw e;
        }
    }

    private void handleProjection(Object t) {
        try {
            Object p = this.getProjectedObject(t);
            if (this.remainder.isConnected()) {
                Object r = this.getRemainderObject(t);
                this.remainder.emit(r);
                ++this.remainderTuples;
            }
            this.projected.emit(p);
            ++this.projectedTuples;
        }
        catch (IllegalAccessException e) {
            this.error.emit(t);
            ++this.errorTuples;
        }
    }

    static class TypeInfo {
        String name;
        Class type;
        PojoUtils.Setter setter;
        PojoUtils.Getter getter;

        public TypeInfo(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public String toString() {
            String s = new String("'name': " + this.name + " 'type': " + this.type);
            return s;
        }
    }
}

