/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.script;

import com.datatorrent.api.Context;
import com.datatorrent.lib.script.ScriptOperator;
import java.util.HashMap;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptOperator
extends ScriptOperator {
    protected transient ScriptEngineManager sem = new ScriptEngineManager();
    protected transient ScriptEngine engine = this.sem.getEngineByName("JavaScript");
    protected transient SimpleScriptContext scriptContext = new SimpleScriptContext();
    protected transient SimpleBindings scriptBindings = new SimpleBindings();
    protected Map<String, Object> serializableBindings = new HashMap<String, Object>();
    protected Type type = Type.EVAL;
    protected Object evalResult;
    private static final Logger LOG = LoggerFactory.getLogger(JavaScriptOperator.class);

    @Override
    public void process(Map<String, Object> tuple) {
        for (Map.Entry<String, Object> entry : tuple.entrySet()) {
            this.engine.put(entry.getKey(), entry.getValue());
        }
        try {
            switch (this.type) {
                case EVAL: {
                    this.evalResult = this.engine.eval(this.script, (ScriptContext)this.scriptContext);
                    break;
                }
                case INVOKE: {
                    this.evalResult = ((Invocable)((Object)this.engine)).invokeFunction(this.script, new Object[0]);
                    break;
                }
            }
            if (this.isPassThru && this.result.isConnected()) {
                this.result.emit(this.evalResult);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (this.isPassThru && this.outBindings.isConnected()) {
            this.outBindings.emit(this.getBindings());
        }
    }

    @Override
    public Map<String, Object> getBindings() {
        return new HashMap<String, Object>(this.engine.getBindings(100));
    }

    public void setEngineByName(String name) {
        this.engine = this.sem.getEngineByName(name);
    }

    public void setEval(String script) {
        this.type = Type.EVAL;
        this.script = script;
    }

    public void setInvoke(String functionName) {
        this.type = Type.INVOKE;
        this.script = functionName;
    }

    public void endWindow() {
        this.serializableBindings.clear();
        for (Map.Entry<String, Object> entry : this.scriptBindings.entrySet()) {
            if (!this.serializableValue(entry.getValue())) continue;
            this.serializableBindings.put(entry.getKey(), entry.getValue());
        }
        if (!this.isPassThru) {
            this.result.emit(this.evalResult);
            this.outBindings.emit(this.getBindings());
        }
    }

    public void setup(Context.OperatorContext context) {
        for (Map.Entry<String, Object> entry : this.serializableBindings.entrySet()) {
            this.scriptBindings.put(entry.getKey(), entry.getValue());
        }
        this.scriptContext.setBindings(this.scriptBindings, 100);
        this.engine.setContext(this.scriptContext);
        try {
            for (String s : this.setupScripts) {
                this.engine.eval(s, (ScriptContext)this.scriptContext);
            }
        }
        catch (ScriptException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void put(String key, Object val) {
        if (this.serializableValue(val)) {
            this.serializableBindings.put(key, val);
        }
        this.scriptBindings.put(key, val);
    }

    protected boolean serializableValue(Object val) {
        try {
            Class<?> interpretedFunctionClass = Class.forName("sun.org.mozilla.javascript.internal.InterpretedFunction");
            return !ScriptContext.class.isAssignableFrom(val.getClass()) && !interpretedFunctionClass.isAssignableFrom(val.getClass());
        }
        catch (ClassNotFoundException ex) {
            return !ScriptContext.class.isAssignableFrom(val.getClass());
        }
    }

    public static enum Type {
        EVAL,
        INVOKE;

    }
}

