/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.statistics;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.OperatorAnnotation;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.common.util.BaseOperator;
import java.util.ArrayList;

@OperatorAnnotation(partitionable=false)
public class StandardDeviation
extends BaseOperator {
    private ArrayList<Double> values = new ArrayList();
    public final transient DefaultInputPort<Number> data = new DefaultInputPort<Number>(){

        public void process(Number tuple) {
            StandardDeviation.this.values.add(tuple.doubleValue());
        }
    };
    @OutputPortFieldAnnotation(optional=true)
    public final transient DefaultOutputPort<Number> variance = new DefaultOutputPort();
    public final transient DefaultOutputPort<Number> standardDeviation = new DefaultOutputPort();

    public void endWindow() {
        if (this.values.size() == 0) {
            return;
        }
        double mean = 0.0;
        for (Double value : this.values) {
            mean += value.doubleValue();
        }
        mean /= (double)this.values.size();
        double outVal = 0.0;
        for (Double value : this.values) {
            outVal += (value - mean) * (value - mean);
        }
        outVal /= (double)this.values.size();
        if (this.variance.isConnected()) {
            this.variance.emit((Object)outVal);
        }
        this.standardDeviation.emit((Object)Math.sqrt(outVal));
        this.values = new ArrayList();
    }
}

