/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.statistics;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.OperatorAnnotation;
import com.datatorrent.lib.util.BaseNumberValueOperator;

@OperatorAnnotation(partitionable=false)
public class WeightedMeanOperator<V extends Number>
extends BaseNumberValueOperator<V> {
    private double weightedSum;
    private double weightedCount;
    private double currentWeight;
    public final transient DefaultInputPort<V> data = new DefaultInputPort<V>(){

        public void process(V tuple) {
            WeightedMeanOperator.this.weightedSum += WeightedMeanOperator.this.currentWeight * ((Number)tuple).doubleValue();
            WeightedMeanOperator.this.weightedCount += WeightedMeanOperator.this.currentWeight;
        }
    };
    public final transient DefaultInputPort<V> weight = new DefaultInputPort<V>(){

        public void process(V tuple) {
            if (((Number)tuple).doubleValue() != 0.0) {
                WeightedMeanOperator.this.currentWeight = ((Number)tuple).doubleValue();
            }
        }
    };
    public final transient DefaultOutputPort<V> mean = new DefaultOutputPort();

    public void setup(Context.OperatorContext arg0) {
        this.currentWeight = 1.0;
    }

    public void endWindow() {
        if (this.weightedCount != 0.0) {
            this.mean.emit(this.getAverage());
        }
        this.weightedSum = 0.0;
        this.weightedCount = 0.0;
    }

    public V getAverage() {
        Number val;
        if (this.weightedSum == 0.0) {
            return null;
        }
        Object num = this.getValue(this.weightedSum);
        switch (this.getType()) {
            case DOUBLE: {
                val = ((Number)num).doubleValue() / this.weightedCount;
                break;
            }
            case INTEGER: {
                val = (int)((double)((Number)num).intValue() / this.weightedCount);
                break;
            }
            case FLOAT: {
                val = new Float((double)((Number)num).floatValue() / this.weightedCount);
                break;
            }
            case LONG: {
                val = (long)((double)((Number)num).longValue() / this.weightedCount);
                break;
            }
            case SHORT: {
                val = (short)((double)((Number)num).shortValue() / this.weightedCount);
                break;
            }
            default: {
                val = ((Number)num).doubleValue() / this.weightedCount;
            }
        }
        return (V)val;
    }
}

