/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.stream;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.api.annotation.OperatorAnnotation;
import java.util.Collection;
import javax.validation.constraints.Min;

@OperatorAnnotation(partitionable=false)
public abstract class AbstractAggregator<T>
implements Operator {
    protected Collection<T> collection;
    @Min(value=0L)
    private int size = 0;
    public final transient DefaultInputPort<T> input = new DefaultInputPort<T>(){

        public void process(T tuple) {
            if (AbstractAggregator.this.collection == null) {
                AbstractAggregator.this.collection = AbstractAggregator.this.getNewCollection(AbstractAggregator.this.size);
            }
            AbstractAggregator.this.collection.add(tuple);
            if (AbstractAggregator.this.collection.size() == AbstractAggregator.this.size) {
                AbstractAggregator.this.output.emit(AbstractAggregator.this.collection);
                AbstractAggregator.this.collection = null;
            }
        }
    };
    public final transient DefaultOutputPort<Collection<T>> output = new DefaultOutputPort();

    public void setSize(int size) {
        this.size = size;
    }

    @Min(value=0L)
    public int getSize() {
        return this.size;
    }

    public abstract Collection<T> getNewCollection(int var1);

    public void beginWindow(long windowId) {
    }

    public void endWindow() {
        if (this.size == 0 && this.collection != null) {
            this.output.emit(this.collection);
            this.collection = null;
        }
    }

    public void setup(Context.OperatorContext context) {
    }

    public void teardown() {
    }
}

