/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.stream;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.common.util.BaseOperator;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevNullCounter<K>
extends BaseOperator {
    public final transient DefaultInputPort<K> data = new DefaultInputPort<K>(){

        public void process(K tuple) {
            ++DevNullCounter.this.tuple_count;
        }
    };
    private static Logger log = LoggerFactory.getLogger(DevNullCounter.class);
    private long windowStartTime = 0L;
    long[] tuple_numbers = null;
    long[] time_numbers = null;
    int tuple_index = 0;
    int count_denominator = 1;
    long count_windowid = 0L;
    long tuple_count = 1L;
    private boolean debug = true;
    @Min(value=1L)
    private int rollingwindowcount = 1;

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean i) {
        this.debug = i;
    }

    public void setRollingwindowcount(int val) {
        this.rollingwindowcount = val;
    }

    public void setup(Context.OperatorContext context) {
        this.windowStartTime = 0L;
        if (this.rollingwindowcount != 1) {
            this.tuple_numbers = new long[this.rollingwindowcount];
            this.time_numbers = new long[this.rollingwindowcount];
            for (int i = this.tuple_numbers.length; i > 0; --i) {
                this.tuple_numbers[i - 1] = 0L;
                this.time_numbers[i - 1] = 0L;
            }
            this.tuple_index = 0;
        }
    }

    public void beginWindow(long windowId) {
        if (this.tuple_count != 0L) {
            this.windowStartTime = System.currentTimeMillis();
            this.tuple_count = 0L;
        }
    }

    public void endWindow() {
        long average;
        if (!this.debug) {
            return;
        }
        if (this.tuple_count == 0L) {
            return;
        }
        long elapsedTime = System.currentTimeMillis() - this.windowStartTime;
        if (elapsedTime == 0L) {
            elapsedTime = 1L;
        }
        long tuples_per_sec = this.tuple_count * 1000L / elapsedTime;
        if (this.rollingwindowcount == 1) {
            average = tuples_per_sec;
        } else {
            long slots;
            if (this.count_denominator == this.rollingwindowcount) {
                this.tuple_numbers[this.tuple_index] = this.tuple_count;
                this.time_numbers[this.tuple_index] = elapsedTime;
                slots = this.rollingwindowcount;
                ++this.tuple_index;
                if (this.tuple_index == this.rollingwindowcount) {
                    this.tuple_index = 0;
                }
            } else {
                this.tuple_numbers[this.count_denominator - 1] = this.tuple_count;
                this.time_numbers[this.count_denominator - 1] = elapsedTime;
                slots = this.count_denominator;
                ++this.count_denominator;
            }
            long time_slot = 0L;
            long numtuples = 0L;
            int i = 0;
            while ((long)i < slots) {
                numtuples += this.tuple_numbers[i];
                time_slot += this.time_numbers[i];
                ++i;
            }
            average = numtuples * 1000L / time_slot;
        }
        log.debug(String.format("\nWindowid (%d), Time (%d ms): The rate for %d tuples is %d. This window had %d tuples_per_sec ", this.count_windowid++, elapsedTime, this.tuple_count, average, tuples_per_sec));
    }
}

