/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.stream;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.Stateless;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.netlet.util.DTThrowable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class JsonByteArrayOperator
extends BaseOperator {
    private Character CONCAT_CHAR = Character.valueOf('_');
    private static final Logger logger = LoggerFactory.getLogger(JsonByteArrayOperator.class);
    public final transient DefaultInputPort<byte[]> input = new DefaultInputPort<byte[]>(){

        private void getFlatMap(JSONObject jSONObject, Map<String, Object> map, String keyPrefix) throws Exception {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String insertKey = keyPrefix == null ? key : keyPrefix + JsonByteArrayOperator.this.CONCAT_CHAR + key;
                JSONObject value = jSONObject.optJSONObject(key);
                if (value == null) {
                    map.put(insertKey, jSONObject.get(key));
                    continue;
                }
                this.getFlatMap(value, map, insertKey);
            }
        }

        public void process(byte[] message) {
            String inputString = new String(message);
            try {
                JSONObject jSONObject = new JSONObject(inputString);
                JsonByteArrayOperator.this.outputJsonObject.emit((Object)jSONObject);
                if (JsonByteArrayOperator.this.outputMap.isConnected()) {
                    Iterator iterator = jSONObject.keys();
                    HashMap<String, String> map = new HashMap<String, String>();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        map.put(key, jSONObject.getString(key));
                    }
                    JsonByteArrayOperator.this.outputMap.emit(map);
                }
                if (JsonByteArrayOperator.this.outputFlatMap.isConnected()) {
                    HashMap<String, Object> flatMap = new HashMap<String, Object>();
                    this.getFlatMap(jSONObject, flatMap, null);
                    JsonByteArrayOperator.this.outputFlatMap.emit(flatMap);
                }
            }
            catch (Throwable ex) {
                DTThrowable.rethrow((Throwable)ex);
            }
        }
    };
    public final transient DefaultOutputPort<HashMap<String, Object>> outputMap = new DefaultOutputPort();
    public final transient DefaultOutputPort<JSONObject> outputJsonObject = new DefaultOutputPort();
    public final transient DefaultOutputPort<HashMap<String, Object>> outputFlatMap = new DefaultOutputPort();

    public void setConcatenationCharacter(char c) {
        this.CONCAT_CHAR = Character.valueOf(c);
    }
}

