/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.streamquery;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.OperatorAnnotation;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.lib.streamquery.condition.Condition;
import com.datatorrent.lib.streamquery.condition.HavingCondition;
import com.datatorrent.lib.streamquery.function.FunctionIndex;
import com.datatorrent.lib.streamquery.index.ColumnIndex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

@OperatorAnnotation(partitionable=false)
public class GroupByHavingOperator
extends BaseOperator {
    private ArrayList<FunctionIndex> aggregates = new ArrayList();
    private ArrayList<ColumnIndex> columnGroupIndexes = new ArrayList();
    private Condition condition;
    private ArrayList<HavingCondition> havingConditions = new ArrayList();
    private ArrayList<Map<String, Object>> rows = new ArrayList();
    public final transient DefaultInputPort<Map<String, Object>> inport = new DefaultInputPort<Map<String, Object>>(){

        public void process(Map<String, Object> tuple) {
            if (GroupByHavingOperator.this.condition != null && !GroupByHavingOperator.this.condition.isValidRow(tuple)) {
                return;
            }
            GroupByHavingOperator.this.rows.add(tuple);
        }
    };
    public final transient DefaultOutputPort<Map<String, Object>> outport = new DefaultOutputPort();

    public void addAggregateIndex(@NotNull FunctionIndex index) {
        this.aggregates.add(index);
    }

    public void addColumnGroupByIndex(@NotNull ColumnIndex index) {
        this.columnGroupIndexes.add(index);
    }

    public void addHavingCondition(@NotNull HavingCondition condition) {
        this.havingConditions.add(condition);
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void endWindow() {
        if (this.columnGroupIndexes.size() == 0) {
            this.rows = new ArrayList();
            return;
        }
        HashMap<MultiKeyCompare, ArrayList> groups = new HashMap<MultiKeyCompare, ArrayList>();
        for (Map<String, Object> map : this.rows) {
            ArrayList subRows;
            MultiKeyCompare key = new MultiKeyCompare();
            for (ColumnIndex index : this.columnGroupIndexes) {
                key.addCompareKey(map.get(index.getColumn()));
            }
            if (groups.containsKey(key)) {
                subRows = (ArrayList)groups.get(key);
            } else {
                subRows = new ArrayList();
                groups.put(key, subRows);
            }
            subRows.add(map);
        }
        for (Map.Entry entry : groups.entrySet()) {
            ArrayList subRows = (ArrayList)entry.getValue();
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (ColumnIndex index : this.columnGroupIndexes) {
                index.filter((Map)subRows.get(0), result);
            }
            for (FunctionIndex aggregate : this.aggregates) {
                try {
                    aggregate.filter(subRows, result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            boolean isValidHaving = true;
            for (HavingCondition condition : this.havingConditions) {
                try {
                    isValidHaving &= condition.isValidAggregate(subRows);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            if (!isValidHaving) continue;
            this.outport.emit(result);
        }
        this.rows = new ArrayList();
    }

    private class MultiKeyCompare
    implements Comparable {
        ArrayList<Object> compareKeys = new ArrayList();

        private MultiKeyCompare() {
        }

        public boolean equals(Object other) {
            if (other instanceof MultiKeyCompare && this.compareKeys.size() != ((MultiKeyCompare)other).compareKeys.size()) {
                return false;
            }
            for (int i = 0; i < this.compareKeys.size(); ++i) {
                if (this.compareKeys.get(i).equals(((MultiKeyCompare)other).compareKeys.get(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hashCode = 0;
            for (int i = 0; i < this.compareKeys.size(); ++i) {
                hashCode += this.compareKeys.get(i).hashCode();
            }
            return hashCode;
        }

        public int compareTo(Object other) {
            if (this.equals(other)) {
                return 0;
            }
            return -1;
        }

        public void addCompareKey(Object value) {
            this.compareKeys.add(value);
        }
    }
}

