/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.streamquery;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.api.annotation.OperatorAnnotation;
import com.datatorrent.lib.streamquery.function.FunctionIndex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@OperatorAnnotation(partitionable=false)
public class SelectFunctionOperator
implements Operator {
    private ArrayList<Map<String, Object>> rows;
    private ArrayList<FunctionIndex> functions = new ArrayList();
    public final transient DefaultInputPort<Map<String, Object>> inport = new DefaultInputPort<Map<String, Object>>(){

        public void process(Map<String, Object> row) {
            SelectFunctionOperator.this.rows.add(row);
        }
    };
    public final transient DefaultOutputPort<Map<String, Object>> outport = new DefaultOutputPort();

    public void setup(Context.OperatorContext context) {
    }

    public void teardown() {
    }

    public void beginWindow(long windowId) {
        this.rows = new ArrayList();
    }

    public void endWindow() {
        if (this.functions.size() == 0) {
            return;
        }
        HashMap<String, Object> collect = new HashMap<String, Object>();
        for (FunctionIndex function : this.functions) {
            try {
                function.filter(this.rows, collect);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.outport.emit(collect);
    }

    public void addSqlFunction(FunctionIndex function) {
        this.functions.add(function);
    }
}

