/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.streamquery.function;

import com.datatorrent.lib.streamquery.function.FunctionIndex;
import java.util.ArrayList;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;

public class AverageFunction
extends FunctionIndex {
    public AverageFunction(@NotNull String column, String alias) {
        super(column, alias);
    }

    @Override
    public Object compute(@NotNull ArrayList<Map<String, Object>> rows) throws Exception {
        if (rows.size() == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (Map<String, Object> row : rows) {
            sum += ((Number)row.get(this.column)).doubleValue();
        }
        return sum / (double)rows.size();
    }

    @Override
    protected String aggregateName() {
        if (!StringUtils.isEmpty((String)this.alias)) {
            return this.alias;
        }
        return "AVG(" + this.column + ")";
    }
}

