/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.streamquery.function;

import com.datatorrent.lib.streamquery.function.FunctionIndex;
import java.util.ArrayList;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;

public class CountFunction
extends FunctionIndex {
    public CountFunction(@NotNull String column, String alias) {
        super(column, alias);
    }

    @Override
    public Object compute(ArrayList<Map<String, Object>> rows) throws Exception {
        if (this.column.equals("*")) {
            return rows.size();
        }
        long count = 0L;
        for (Map<String, Object> row : rows) {
            if (!row.containsKey(this.column) || row.get(this.column) == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected String aggregateName() {
        if (!StringUtils.isEmpty((String)this.alias)) {
            return this.alias;
        }
        return "COUNT(" + this.column + ")";
    }
}

