/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.streamquery.function;

import com.datatorrent.lib.streamquery.function.FunctionIndex;
import java.util.ArrayList;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;

public class MaxMinFunction
extends FunctionIndex {
    private boolean isMax = true;

    public MaxMinFunction(@NotNull String column, String alias, boolean isMin) {
        super(column, alias);
        this.isMax = !isMin;
    }

    @Override
    public Object compute(ArrayList<Map<String, Object>> rows) throws Exception {
        double minMax = 0.0;
        for (Map<String, Object> row : rows) {
            double value = ((Number)row.get(this.column)).doubleValue();
            if (!(this.isMax && minMax < value) && (this.isMax || !(minMax > value))) continue;
            minMax = value;
        }
        return minMax;
    }

    @Override
    protected String aggregateName() {
        if (!StringUtils.isEmpty((String)this.alias)) {
            return this.alias;
        }
        if (this.isMax) {
            return "MAX(" + this.column + ")";
        }
        return "MIN(" + this.column + ")";
    }

    public boolean isMax() {
        return this.isMax;
    }

    public void setMax(boolean isMax) {
        this.isMax = isMax;
    }
}

