/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.streamquery.index;

import com.datatorrent.lib.streamquery.index.ColumnIndex;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class RoundDoubleIndex
extends ColumnIndex {
    private int rounder = 1;

    public RoundDoubleIndex(@NotNull String column, String alias, int numDecimals) {
        super(column, alias);
        if (numDecimals > 0) {
            this.rounder = (int)Math.pow(10.0, numDecimals);
        }
    }

    @Override
    public void filter(@NotNull Map<String, Object> row, @NotNull Map<String, Object> collect) {
        if (!row.containsKey(this.column)) {
            return;
        }
        double value = (Double)row.get(this.column);
        value = Math.round(value * (double)this.rounder) / (long)this.rounder;
        String name = this.getColumn();
        if (this.alias != null) {
            name = this.alias;
        }
        collect.put(name, value);
    }
}

