/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.testbench;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.common.util.BaseOperator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class EventClassifier
extends BaseOperator {
    public final transient DefaultInputPort<HashMap<String, Double>> event = new DefaultInputPort<HashMap<String, Double>>(){

        public void process(HashMap<String, Double> tuple) {
            for (Map.Entry<String, Double> e : tuple.entrySet()) {
                String inkey = e.getKey();
                ArrayList<Integer> alist = null;
                if (EventClassifier.this.inkeys != null) {
                    alist = EventClassifier.this.inkeys.get(e.getKey());
                }
                if (alist == null) {
                    alist = EventClassifier.this.noweight;
                }
                int rval = EventClassifier.this.random.nextInt(alist.get(alist.size() - 1));
                int j = 0;
                int wval = 0;
                for (Integer ew : alist) {
                    if ((wval += ew.intValue()) >= rval) break;
                    ++j;
                }
                HashMap<String, Double> otuple = new HashMap<String, Double>(1);
                String key = EventClassifier.this.wtostr_index.get(j);
                Double keyval = null;
                if (EventClassifier.this.hasvalues) {
                    if (EventClassifier.this.voper == value_operation.VOPR_REPLACE) {
                        keyval = EventClassifier.this.keys.get(key);
                    } else if (EventClassifier.this.voper == value_operation.VOPR_ADD) {
                        keyval = EventClassifier.this.keys.get(key) + e.getValue();
                    } else if (EventClassifier.this.voper == value_operation.VOPR_MULT) {
                        keyval = EventClassifier.this.keys.get(key) * e.getValue();
                    } else if (EventClassifier.this.voper == value_operation.VOPR_APPEND) {
                        keyval = EventClassifier.this.keys.get(key);
                    }
                } else {
                    keyval = e.getValue();
                }
                otuple.put(key + "," + inkey, keyval);
                EventClassifier.this.data.emit(otuple);
            }
        }
    };
    public final transient DefaultOutputPort<HashMap<String, Double>> data = new DefaultOutputPort();
    HashMap<String, Double> keys = new HashMap();
    HashMap<Integer, String> wtostr_index = new HashMap();
    HashMap<String, ArrayList<Integer>> inkeys = null;
    ArrayList<Integer> noweight = null;
    boolean hasvalues = false;
    int total_weight = 0;
    private Random random = new Random();
    value_operation voper = value_operation.VOPR_REPLACE;

    public void setOperationReplace() {
        this.voper = value_operation.VOPR_REPLACE;
    }

    public void setOperationAdd() {
        this.voper = value_operation.VOPR_ADD;
    }

    public void setOperationMult() {
        this.voper = value_operation.VOPR_MULT;
    }

    public void setOperationAppend() {
        this.voper = value_operation.VOPR_MULT;
    }

    public void setKeyWeights(HashMap<String, ArrayList<Integer>> map) {
        if (this.inkeys == null) {
            this.inkeys = new HashMap();
        }
        for (Map.Entry<String, ArrayList<Integer>> e : map.entrySet()) {
            this.inkeys.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, ArrayList<Integer>> e : this.inkeys.entrySet()) {
            ArrayList<Integer> list = e.getValue();
            int total = 0;
            for (Integer i : list) {
                total += i.intValue();
            }
            list.add(total);
        }
    }

    public void setup(Context.OperatorContext context) {
        this.noweight = new ArrayList();
        for (int i = 0; i < this.keys.size(); ++i) {
            this.noweight.add(100);
            this.total_weight += 100;
        }
        this.noweight.add(this.total_weight);
    }

    public void setKeyMap(HashMap<String, Double> map) {
        int i = 0;
        boolean foundvalue = false;
        for (Map.Entry<String, Double> e : map.entrySet()) {
            this.keys.put(e.getKey(), e.getValue());
            foundvalue = foundvalue || e.getValue() != null;
            this.wtostr_index.put(i, e.getKey());
            ++i;
        }
        this.hasvalues = foundvalue;
    }

    static enum value_operation {
        VOPR_REPLACE,
        VOPR_ADD,
        VOPR_MULT,
        VOPR_APPEND;

    }
}

