/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.testbench;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.InputOperator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventGenerator
implements InputOperator {
    private static final Logger LOG = LoggerFactory.getLogger(EventGenerator.class);
    public final transient DefaultOutputPort<String> string_data = new DefaultOutputPort();
    public final transient DefaultOutputPort<HashMap<String, Double>> hash_data = new DefaultOutputPort();
    public final transient DefaultOutputPort<HashMap<String, Number>> count = new DefaultOutputPort();
    public static final String OPORT_COUNT_TUPLE_AVERAGE = "avg";
    public static final String OPORT_COUNT_TUPLE_COUNT = "count";
    public static final String OPORT_COUNT_TUPLE_TIME = "window_time";
    public static final String OPORT_COUNT_TUPLE_TUPLES_PERSEC = "tuples_per_sec";
    public static final String OPORT_COUNT_TUPLE_WINDOWID = "window_id";
    protected static final int TUPLES_BLAST_DEFAULT = 10000;
    @Min(value=1L)
    private int tuples_blast = 10000;
    @Min(value=1L)
    protected int maxCountOfWindows = Integer.MAX_VALUE;
    HashMap<String, Double> keys = new HashMap();
    HashMap<Integer, String> wtostr_index = new HashMap();
    ArrayList<Integer> weights;
    int total_weight = 0;
    private final transient Random random = new Random();
    public static final int ROLLING_WINDOW_COUNT_DEFAULT = 1;
    @Min(value=1L)
    private int rolling_window_count = 1;
    transient long[] tuple_numbers = null;
    transient long[] time_numbers = null;
    transient int tuple_index = 0;
    transient int count_denominator = 1;
    transient int count_windowid = 0;
    private transient long windowStartTime = 0L;
    private transient int generatedTupleCount = 0;
    @NotNull
    private String keysHelper = null;
    private String weightsHelper = null;
    private String valuesHelper = null;
    @NotNull
    private String[] keysArray = null;
    private String[] weightsArray = null;
    private String[] valuesArray = null;

    public void setup(Context.OperatorContext context) {
        int i;
        if (this.rolling_window_count != 1) {
            this.tuple_numbers = new long[this.rolling_window_count];
            this.time_numbers = new long[this.rolling_window_count];
            for (i = this.tuple_numbers.length; i > 0; --i) {
                this.tuple_numbers[i - 1] = 0L;
                this.time_numbers[i - 1] = 0L;
            }
            this.tuple_index = 0;
        }
        i = 0;
        this.total_weight = 0;
        for (String s : this.keysArray) {
            if (this.weightsArray != null && this.weightsArray.length != 0) {
                if (this.weights == null) {
                    this.weights = new ArrayList();
                }
                this.weights.add(Integer.parseInt(this.weightsArray[i]));
                this.total_weight += Integer.parseInt(this.weightsArray[i]);
            } else {
                ++this.total_weight;
            }
            if (this.valuesArray != null && this.valuesArray.length != 0) {
                this.keys.put(s, new Double(Double.parseDouble(this.valuesArray[i])));
            } else {
                this.keys.put(s, 0.0);
            }
            this.wtostr_index.put(i, s);
            ++i;
        }
    }

    public void beginWindow(long windowId) {
        if (this.count.isConnected()) {
            this.generatedTupleCount = 0;
            this.windowStartTime = System.currentTimeMillis();
        }
    }

    public void endWindow() {
        if (this.count.isConnected() && this.generatedTupleCount > 0) {
            long average;
            long elapsedTime = System.currentTimeMillis() - this.windowStartTime;
            if (elapsedTime == 0L) {
                elapsedTime = 1L;
            }
            long tcount = this.generatedTupleCount;
            if (this.rolling_window_count == 1) {
                average = tcount * 1000L / elapsedTime;
            } else {
                int slots;
                if (this.count_denominator == this.rolling_window_count) {
                    this.tuple_numbers[this.tuple_index] = tcount;
                    this.time_numbers[this.tuple_index] = elapsedTime;
                    slots = this.rolling_window_count;
                    ++this.tuple_index;
                    if (this.tuple_index == this.rolling_window_count) {
                        this.tuple_index = 0;
                    }
                } else {
                    this.tuple_numbers[this.count_denominator - 1] = tcount;
                    this.time_numbers[this.count_denominator - 1] = elapsedTime;
                    slots = this.count_denominator++;
                }
                long time_slot = 0L;
                long num_tuples = 0L;
                for (int i = 0; i < slots; ++i) {
                    num_tuples += this.tuple_numbers[i];
                    time_slot += this.time_numbers[i];
                }
                average = num_tuples * 1000L / time_slot;
            }
            HashMap<String, Number> tuples = new HashMap<String, Number>();
            tuples.put(OPORT_COUNT_TUPLE_AVERAGE, new Long(average));
            tuples.put(OPORT_COUNT_TUPLE_COUNT, new Long(tcount));
            tuples.put(OPORT_COUNT_TUPLE_TIME, new Long(elapsedTime));
            tuples.put(OPORT_COUNT_TUPLE_TUPLES_PERSEC, new Long(tcount * 1000L / elapsedTime));
            tuples.put(OPORT_COUNT_TUPLE_WINDOWID, new Integer(this.count_windowid++));
            this.count.emit(tuples);
        }
        if (--this.maxCountOfWindows == 0) {
            LOG.info("reached maxCountOfWindows, interrupting thread.");
            Thread.currentThread().interrupt();
        }
    }

    public void teardown() {
    }

    public void setMaxCountOfWindows(int i) {
        this.maxCountOfWindows = i;
    }

    public String getKeysHelper() {
        return this.keysHelper;
    }

    public void setKeysHelper(String keys) {
        LOG.debug("in key setter");
        this.keysHelper = keys;
        this.keysArray = this.keysHelper.split(",");
    }

    public String getWeightsHelper() {
        return this.weightsHelper;
    }

    public void setWeightsHelper(String weight) {
        this.weightsArray = weight.isEmpty() ? null : weight.split(",");
    }

    public String getValuesHelper() {
        return this.valuesHelper;
    }

    public void setValuesHelper(String value) {
        this.valuesArray = value.isEmpty() ? null : value.split(",");
    }

    public void setTuplesBlast(int tuples_blast) {
        this.tuples_blast = tuples_blast;
    }

    public void setRollingWindowCount(int r) {
        this.rolling_window_count = r;
    }

    public void emitTuples() {
        int j = 0;
        int i = this.tuples_blast;
        while (i-- > 0) {
            if (this.weights != null) {
                int rval = this.random.nextInt(this.total_weight);
                j = 0;
                int wval = 0;
                for (Integer e : this.weights) {
                    if ((wval += e.intValue()) >= rval) break;
                    ++j;
                }
            } else {
                ++j;
                j %= this.keys.size();
            }
            String tuple_key = this.wtostr_index.get(j);
            ++this.generatedTupleCount;
            if (this.string_data.isConnected()) {
                this.string_data.emit((Object)tuple_key);
            }
            if (!this.hash_data.isConnected()) continue;
            HashMap<String, Double> tuple = new HashMap<String, Double>(1);
            tuple.put(tuple_key, this.keys.get(tuple_key));
            this.hash_data.emit(tuple);
        }
    }
}

