/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.testbench;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.lib.util.KeyValPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class EventIncrementer
extends BaseOperator {
    public final transient DefaultInputPort<HashMap<String, ArrayList<Integer>>> seed = new DefaultInputPort<HashMap<String, ArrayList<Integer>>>(){

        public void process(HashMap<String, ArrayList<Integer>> tuple) {
            ++EventIncrementer.this.tuple_count;
            for (Map.Entry<String, ArrayList<Integer>> e : tuple.entrySet()) {
                if (EventIncrementer.this.keys.length != e.getValue().size()) {
                    return;
                }
                ArrayList<KeyValPair<String, Double>> alist = new ArrayList<KeyValPair<String, Double>>(EventIncrementer.this.keys.length);
                int j = 0;
                for (Integer s : e.getValue()) {
                    KeyValPair<String, Double> d = new KeyValPair<String, Double>(EventIncrementer.this.keys[j], new Double(s.doubleValue()));
                    alist.add(d);
                    ++j;
                }
                EventIncrementer.this.vmap.put(e.getKey(), alist);
                EventIncrementer.this.emitDataTuple(e.getKey(), alist);
            }
        }
    };
    public final transient DefaultInputPort<HashMap<String, HashMap<String, Integer>>> increment = new DefaultInputPort<HashMap<String, HashMap<String, Integer>>>(){

        public void process(HashMap<String, HashMap<String, Integer>> tuple) {
            ++EventIncrementer.this.tuple_count;
            for (Map.Entry<String, HashMap<String, Integer>> e : tuple.entrySet()) {
                String key = e.getKey();
                ArrayList<KeyValPair<String, Double>> alist = EventIncrementer.this.vmap.get(key);
                if (alist == null) continue;
                for (Map.Entry<String, Integer> o : e.getValue().entrySet()) {
                    String dimension = o.getKey();
                    int j = 0;
                    int cur_slot = 0;
                    int new_slot = 0;
                    for (KeyValPair<String, Double> d : alist) {
                        if (dimension.equals(d.getKey())) {
                            cur_slot = ((Double)d.getValue()).intValue();
                            Double nval = EventIncrementer.this.getNextNumber((Double)d.getValue(), EventIncrementer.this.delta / 100.0 * (double)(o.getValue() % 100), EventIncrementer.this.low_limits[j], EventIncrementer.this.high_limits[j]);
                            new_slot = nval.intValue();
                            alist.get(j).setValue(nval);
                            break;
                        }
                        ++j;
                    }
                    if (cur_slot == new_slot) continue;
                    EventIncrementer.this.emitDataTuple(key, alist);
                }
            }
        }
    };
    public final transient DefaultOutputPort<HashMap<String, String>> data = new DefaultOutputPort();
    public final transient DefaultOutputPort<HashMap<String, Integer>> count = new DefaultOutputPort();
    public static final String OPORT_COUNT_TUPLE_COUNT = "count";
    HashMap<String, ArrayList<KeyValPair<String, Double>>> vmap = new HashMap();
    String[] keys = null;
    double[] low_limits = null;
    double[] high_limits = null;
    private double sign = -1.0;
    final double low_limit_default_val = 0.0;
    final double high_limit_default_val = 100.0;
    double delta = 1.0;
    int tuple_count = 0;

    public void setDelta(double i) {
        this.delta = i;
    }

    public void setKeylimits(ArrayList<String> klist, ArrayList<Double> low, ArrayList<Double> high) {
        if (low.size() != high.size()) {
            throw new IllegalArgumentException(String.format("Array sizes for low limits (%d), and high limits (%d) do not match", low.size(), high.size()));
        }
        if (klist.size() != low.size()) {
            throw new IllegalArgumentException(String.format("Array sizes for low limits (%d), does not match number of keys (%d)", low.size(), klist.size()));
        }
        if (this.low_limits == null) {
            this.low_limits = new double[low.size()];
        }
        if (this.high_limits == null) {
            this.high_limits = new double[high.size()];
        }
        if (this.keys == null) {
            this.keys = new String[klist.size()];
        }
        for (int i = 0; i < low.size(); ++i) {
            this.low_limits[i] = low.get(i);
            this.high_limits[i] = high.get(i);
            this.keys[i] = klist.get(i);
        }
    }

    public double getNextNumber(double current, double increment, double low, double high) {
        double ret = current;
        double range = high - low;
        if (increment > range) {
            ret = current;
        } else {
            this.sign *= -1.0;
            if ((ret += this.sign * increment) < low) {
                ret = (low + high) / 2.0;
            }
            if (ret > high) {
                ret = (low + high) / 2.0;
            }
        }
        return ret;
    }

    public void emitDataTuple(String key, ArrayList<KeyValPair<String, Double>> list) {
        if (!this.data.isConnected()) {
            return;
        }
        HashMap<String, String> tuple = new HashMap<String, String>(1);
        String val = new String();
        for (KeyValPair<String, Double> d : list) {
            if (!val.isEmpty()) {
                val = val + ",";
            }
            Integer ival = ((Double)d.getValue()).intValue();
            val = val + ival.toString();
        }
        tuple.put(key, val);
        this.data.emit(tuple);
    }

    public void beginWindow(long windowId) {
        this.tuple_count = 0;
    }

    public void endWindow() {
        if (this.count.isConnected()) {
            HashMap<String, Integer> tuple = new HashMap<String, Integer>(1);
            tuple.put(OPORT_COUNT_TUPLE_COUNT, new Integer(this.tuple_count));
            this.count.emit(tuple);
        }
    }
}

