/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.testbench;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.common.util.BaseOperator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class FilteredEventClassifier<T>
extends BaseOperator {
    public final transient DefaultInputPort<HashMap<String, T>> data = new DefaultInputPort<HashMap<String, T>>(){

        public void process(HashMap<String, T> tuple) {
            int fval = FilteredEventClassifier.this.random.nextInt(FilteredEventClassifier.this.total_filter);
            if (fval >= FilteredEventClassifier.this.pass_filter) {
                return;
            }
            for (Map.Entry e : tuple.entrySet()) {
                String[] twokeys = e.getKey().split(",");
                if (twokeys.length != 2) continue;
                String inkey = twokeys[1];
                ArrayList<Integer> alist = FilteredEventClassifier.this.noweight;
                if (FilteredEventClassifier.this.inkeys != null) {
                    alist = FilteredEventClassifier.this.inkeys.get(inkey);
                }
                int rval = FilteredEventClassifier.this.random.nextInt(alist.get(alist.size() - 1));
                int j = 0;
                int wval = 0;
                for (Integer ew : alist) {
                    if ((wval += ew.intValue()) > rval) break;
                    ++j;
                }
                HashMap otuple = new HashMap(1);
                String key = FilteredEventClassifier.this.wtostr_index.get(j);
                Object keyval = FilteredEventClassifier.this.hasvalues ? FilteredEventClassifier.this.keys.get(key) : e.getValue();
                otuple.put(key + "," + inkey, keyval);
                FilteredEventClassifier.this.filter.emit(otuple);
            }
        }
    };
    public final transient DefaultOutputPort<HashMap<String, T>> filter = new DefaultOutputPort();
    HashMap<String, T> keys = new HashMap();
    HashMap<Integer, String> wtostr_index = new HashMap();
    HashMap<String, ArrayList<Integer>> inkeys = null;
    ArrayList<Integer> noweight = null;
    boolean hasvalues = false;
    int total_weight = 0;
    int pass_filter = 0;
    int total_filter = 0;
    private Random random = new Random();

    public void setPassFilter(int i) {
        this.pass_filter = i;
    }

    public void setTotalFilter(int i) {
        this.total_filter = i;
    }

    public void setKeyMap(HashMap<String, T> map) {
        int i = 0;
        boolean foundvalue = false;
        for (Map.Entry<String, T> e : map.entrySet()) {
            this.keys.put(e.getKey(), e.getValue());
            foundvalue = foundvalue || e.getValue() != null;
            this.wtostr_index.put(i, e.getKey());
            ++i;
        }
        this.hasvalues = foundvalue;
    }

    public void setup(Context.OperatorContext context) {
        this.noweight = new ArrayList();
        for (int i = 0; i < this.keys.size(); ++i) {
            this.noweight.add(100);
            this.total_weight += 100;
        }
        this.noweight.add(this.total_weight);
        if (this.pass_filter > this.total_filter) {
            throw new IllegalArgumentException(String.format("Pass filter (%d) cannot be >= Total filter (%d)", this.pass_filter, this.total_filter));
        }
    }

    public void setKeyWeights(HashMap<String, ArrayList<Integer>> map) {
        if (this.inkeys == null) {
            this.inkeys = new HashMap();
        }
        for (Map.Entry<String, ArrayList<Integer>> e : map.entrySet()) {
            this.inkeys.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, ArrayList<Integer>> e : this.inkeys.entrySet()) {
            ArrayList<Integer> list = e.getValue();
            int total = 0;
            for (Integer i : list) {
                total += i.intValue();
            }
            list.add(total);
        }
    }
}

