/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.testbench;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.InputOperator;
import com.datatorrent.common.util.BaseOperator;
import java.util.Random;
import javax.validation.constraints.Min;

public class RandomEventGenerator
extends BaseOperator
implements InputOperator {
    public final transient DefaultOutputPort<String> string_data = new DefaultOutputPort();
    public final transient DefaultOutputPort<Integer> integer_data = new DefaultOutputPort();
    private int maxCountOfWindows = Integer.MAX_VALUE;
    @Min(value=1L)
    private int tuplesBlast = 1000;
    @Min(value=1L)
    private int tuplesBlastIntervalMillis = 10;
    private int min_value = 0;
    private int max_value = 100;
    private final Random random = new Random();

    public int getMaxvalue() {
        return this.max_value;
    }

    public int getMinvalue() {
        return this.min_value;
    }

    @Min(value=1L)
    public int getTuplesBlast() {
        return this.tuplesBlast;
    }

    @Min(value=1L)
    public int getTuplesBlastIntervalMillis() {
        return this.tuplesBlastIntervalMillis;
    }

    public void setMaxvalue(int i) {
        this.max_value = i;
    }

    public void setMinvalue(int i) {
        this.min_value = i;
    }

    public void setTuplesBlast(int i) {
        this.tuplesBlast = i;
    }

    public void setTuplesBlastIntervalMillis(int tuplesBlastIntervalMillis) {
        this.tuplesBlastIntervalMillis = tuplesBlastIntervalMillis;
    }

    public void setup(Context.OperatorContext context) {
        if (this.max_value <= this.min_value) {
            throw new IllegalArgumentException(String.format("min_value (%d) should be < max_value(%d)", this.min_value, this.max_value));
        }
    }

    public void setMaxCountOfWindows(int i) {
        this.maxCountOfWindows = i;
    }

    public void endWindow() {
        if (--this.maxCountOfWindows == 0) {
            throw new RuntimeException(new InterruptedException("Finished generating data."));
        }
    }

    public void teardown() {
    }

    public void emitTuples() {
        int range = this.max_value - this.min_value + 1;
        for (int i = 0; i < this.tuplesBlast; ++i) {
            int rval = this.min_value + this.random.nextInt(range);
            if (this.integer_data.isConnected()) {
                this.integer_data.emit((Object)rval);
            }
            if (!this.string_data.isConnected()) continue;
            this.string_data.emit((Object)Integer.toString(rval));
        }
        if (this.tuplesBlastIntervalMillis > 0) {
            try {
                Thread.sleep(this.tuplesBlastIntervalMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

