/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.testbench;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.InputOperator;
import java.util.Random;
import javax.validation.constraints.Min;

public class RandomWordGenerator
implements InputOperator {
    public final transient DefaultOutputPort<byte[]> output = new DefaultOutputPort();
    public static final int MAX_TUPLES_PER_WINDOW = 200000;
    public static final int TUPLE_BYTE_SIZE = 32;
    @Min(value=1L)
    private int tuplesPerWindow = 200000;
    @Min(value=1L)
    private int tupleSize = 32;
    private transient Random random = new Random();
    private int tupleCounter = 0;

    public void setup(Context.OperatorContext context) {
    }

    public void beginWindow(long windowId) {
        this.tupleCounter = 0;
    }

    public void emitTuples() {
        while (this.tupleCounter < this.tuplesPerWindow) {
            byte[] bytes = new byte[this.tupleSize];
            this.random.nextBytes(bytes);
            this.output.emit((Object)bytes);
            ++this.tupleCounter;
        }
    }

    public void endWindow() {
    }

    public void teardown() {
    }

    public void setTuplesPerWindow(int tuplesPerWindow) {
        this.tuplesPerWindow = tuplesPerWindow;
    }

    public int getTuplesPerWindow() {
        return this.tuplesPerWindow;
    }

    public void setTupleSize(int tupleSize) {
        this.tupleSize = tupleSize;
    }

    public int getTupleSize() {
        return this.tupleSize;
    }
}

