/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.transform;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.api.annotation.InputPortFieldAnnotation;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.lib.expression.Expression;
import com.datatorrent.lib.util.PojoUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ClassUtils;

public class TransformOperator
extends BaseOperator
implements Operator.ActivationListener {
    @NotNull
    private Map<String, String> expressionMap = new HashMap<String, String>();
    private List<String> expressionFunctions = new LinkedList<String>();
    private boolean copyMatchingFields = true;
    private transient Map<PojoUtils.Setter, Expression> transformationMap = new HashMap<PojoUtils.Setter, Expression>();
    private Class<?> inputClass;
    private Class<?> outputClass;
    @InputPortFieldAnnotation(schemaRequired=true)
    public final transient DefaultInputPort<Object> input = new DefaultInputPort<Object>(){

        public void setup(Context.PortContext context) {
            TransformOperator.this.inputClass = (Class)context.getValue(Context.PortContext.TUPLE_CLASS);
        }

        public void process(Object o) {
            TransformOperator.this.processTuple(o);
        }
    };
    @OutputPortFieldAnnotation(schemaRequired=true)
    public final transient DefaultOutputPort<Object> output = new DefaultOutputPort<Object>(){

        public void setup(Context.PortContext context) {
            TransformOperator.this.outputClass = (Class)context.getValue(Context.PortContext.TUPLE_CLASS);
        }
    };

    public TransformOperator() {
        this.expressionFunctions.add("java.lang.Math.*");
        this.expressionFunctions.add("org.apache.commons.lang3.StringUtils.*");
        this.expressionFunctions.add("org.apache.commons.lang3.StringEscapeUtils.*");
        this.expressionFunctions.add("org.apache.commons.lang3.time.DurationFormatUtils.*");
        this.expressionFunctions.add("org.apache.commons.lang3.time.DateFormatUtils.*");
    }

    protected void processTuple(Object in) {
        Object out;
        if (!this.inputClass.isAssignableFrom(in.getClass())) {
            throw new RuntimeException("Unexpected tuple received. Received class: " + in.getClass() + ". Expected class: " + this.inputClass.getClass());
        }
        try {
            out = this.outputClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to create new object", e);
        }
        for (Map.Entry<PojoUtils.Setter, Expression> entry : this.transformationMap.entrySet()) {
            PojoUtils.Setter set = entry.getKey();
            Expression expr = entry.getValue();
            set.set(out, expr.execute(in));
        }
        this.output.emit(out);
    }

    public void activate(Context context) {
        if (this.copyMatchingFields) {
            Field[] declaredFields;
            for (Field outputField : declaredFields = this.outputClass.getDeclaredFields()) {
                String outputFieldName = outputField.getName();
                if (this.expressionMap.containsKey(outputFieldName)) continue;
                try {
                    Field inputField = this.inputClass.getDeclaredField(outputFieldName);
                    if (inputField.getType() != outputField.getType()) continue;
                    this.expressionMap.put(outputFieldName, inputField.getName());
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
        }
        for (Map.Entry<String, String> entry : this.expressionMap.entrySet()) {
            Field f;
            String field = entry.getKey();
            String expr = entry.getValue();
            try {
                f = this.outputClass.getDeclaredField(field);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Failed to get output field info", e);
            }
            Class c = ClassUtils.primitiveToWrapper(f.getType());
            PojoUtils.Setter setter = PojoUtils.createSetter(this.outputClass, field, c);
            Expression expression = PojoUtils.createExpression(this.inputClass, expr, c, this.expressionFunctions.toArray(new String[this.expressionFunctions.size()]));
            this.transformationMap.put(setter, expression);
        }
    }

    public void deactivate() {
    }

    public Map<String, String> getExpressionMap() {
        return this.expressionMap;
    }

    public void setExpressionMap(Map<String, String> expressionMap) {
        this.expressionMap = expressionMap;
    }

    public List<String> getExpressionFunctions() {
        return this.expressionFunctions;
    }

    public void setExpressionFunctions(List<String> expressionFunctions) {
        this.expressionFunctions = expressionFunctions;
    }

    public boolean isCopyMatchingFields() {
        return this.copyMatchingFields;
    }

    public void setCopyMatchingFields(boolean copyMatchingFields) {
        this.copyMatchingFields = copyMatchingFields;
    }
}

