/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import com.datatorrent.api.Context;
import com.datatorrent.lib.util.BaseKeyValueOperator;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public abstract class AbstractBaseMatchOperator<K, V extends Comparable>
extends BaseKeyValueOperator<K, V> {
    @NotNull
    private K key;
    private String cmp;
    private V value;
    supported_type type = supported_type.EQ;

    public void setKey(K key) {
        this.key = key;
    }

    @NotNull
    public K getKey() {
        return this.key;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public V getValue() {
        return this.value;
    }

    public void setup(Context.OperatorContext context) {
        if (this.getKey() == null) {
            throw new IllegalArgumentException("Key not set");
        }
        if (this.getValue() == null) {
            throw new IllegalArgumentException("Value not set");
        }
    }

    public int compareValue(V value) {
        return this.getValue().compareTo(value);
    }

    public supported_type getType() {
        return this.type;
    }

    public boolean matchCondition(V value) {
        boolean ret;
        int cval = this.compareValue(value);
        switch (this.type) {
            case LT: {
                ret = cval < 0;
                break;
            }
            case LTE: {
                ret = cval < 0 || cval == 0;
                break;
            }
            case EQ: {
                ret = cval == 0;
                break;
            }
            case NEQ: {
                ret = cval != 0;
                break;
            }
            case GT: {
                ret = cval > 0;
                break;
            }
            case GTE: {
                ret = cval > 0 || cval == 0;
                break;
            }
            default: {
                ret = cval == 0;
            }
        }
        return ret;
    }

    @Pattern(regexp="lte|lt|eq|ne|gt|gte", message="Value has to be one of lte, lt, eq, ne, gt, gte")
    public void setCmp(String cmp) {
        if (cmp.equals("lt")) {
            this.setTypeLT();
        } else if (cmp.equals("lte")) {
            this.setTypeLTE();
        } else if (cmp.equals("eq")) {
            this.setTypeEQ();
        } else if (cmp.equals("ne")) {
            this.setTypeEQ();
        } else if (cmp.equals("gt")) {
            this.setTypeGT();
        } else if (cmp.equals("gte")) {
            this.setTypeGTE();
        } else {
            this.setTypeEQ();
        }
    }

    public void setTypeLT() {
        this.type = supported_type.LT;
    }

    public void setTypeLTE() {
        this.type = supported_type.LTE;
    }

    public void setTypeEQ() {
        this.type = supported_type.EQ;
    }

    public void setTypeNEQ() {
        this.type = supported_type.NEQ;
    }

    public void setTypeGT() {
        this.type = supported_type.GT;
    }

    public void setTypeGTE() {
        this.type = supported_type.GTE;
    }

    public static enum supported_type {
        LTE,
        LT,
        EQ,
        NEQ,
        GT,
        GTE;

    }
}

