/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import com.datatorrent.lib.util.BaseKeyOperator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.PriorityQueue;
import javax.validation.constraints.Min;
import org.apache.commons.lang.mutable.MutableInt;

public abstract class AbstractBaseSortOperator<K>
extends BaseKeyOperator<K> {
    @Min(value=1L)
    int size = 10;
    protected PriorityQueue<K> pqueue = null;
    protected HashMap<K, MutableInt> pmap = new HashMap();

    public void processTuple(ArrayList<K> tuple) {
        for (K e : tuple) {
            this.processTuple(e);
        }
    }

    public void processTuple(K e) {
        if (e == null) {
            return;
        }
        MutableInt count = this.pmap.get(e);
        if (count == null) {
            count = new MutableInt(0);
            this.pmap.put(e, count);
            this.pqueue.add(e);
        }
        count.increment();
    }

    @Min(value=1L)
    public int getSize() {
        return this.size;
    }

    public void setSize(int val) {
        this.size = val;
    }

    public void beginWindow(long windowId) {
        if (this.pqueue == null) {
            this.initializeQueue();
        }
    }

    public void initializeQueue() {
        this.pqueue = new PriorityQueue(this.getSize());
    }

    public abstract boolean doEmitList();

    public abstract boolean doEmitHash();

    public abstract void emitToList(ArrayList<K> var1);

    public abstract void emitToHash(HashMap<K, Integer> var1);

    public void endWindow() {
        K o;
        if (this.pqueue.isEmpty()) {
            return;
        }
        ArrayList<K> tuple = new ArrayList<K>();
        HashMap<K, Integer> htuple = new HashMap<K, Integer>(this.pqueue.size());
        boolean sok = this.doEmitList();
        boolean hok = this.doEmitHash();
        if (sok) {
            tuple = new ArrayList();
        }
        if (hok) {
            htuple = new HashMap(this.pqueue.size());
        }
        while ((o = this.pqueue.poll()) != null) {
            MutableInt count = this.pmap.get(o);
            if (sok) {
                for (int i = 0; i < count.intValue(); ++i) {
                    tuple.add(this.cloneKey(o));
                }
            }
            if (!hok) continue;
            htuple.put(this.cloneKey(o), count.intValue());
        }
        if (sok) {
            this.emitToList(tuple);
        }
        if (hok) {
            this.emitToHash(htuple);
        }
        this.pmap.clear();
        this.pqueue.clear();
    }
}

