/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.InputPortFieldAnnotation;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.common.util.BaseOperator;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDimensionTimeBucketOperator
extends BaseOperator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDimensionTimeBucketOperator.class);
    @InputPortFieldAnnotation(optional=false)
    public final transient DefaultInputPort<Map<String, Object>> in = new DefaultInputPort<Map<String, Object>>(){

        public void process(Map<String, Object> tuple) {
            try {
                long time = AbstractDimensionTimeBucketOperator.this.extractTimeFromTuple(tuple);
                AbstractDimensionTimeBucketOperator.this.calendar.setTimeInMillis(time);
                ArrayList<String> timeBucketList = new ArrayList<String>();
                if ((AbstractDimensionTimeBucketOperator.this.timeBucketFlags & 0x20) != 0) {
                    timeBucketList.add(String.format("Y|%04d", AbstractDimensionTimeBucketOperator.this.calendar.get(1)));
                }
                if ((AbstractDimensionTimeBucketOperator.this.timeBucketFlags & 0x10) != 0) {
                    timeBucketList.add(String.format("M|%04d%02d", AbstractDimensionTimeBucketOperator.this.calendar.get(1), AbstractDimensionTimeBucketOperator.this.calendar.get(2) + 1));
                }
                if ((AbstractDimensionTimeBucketOperator.this.timeBucketFlags & 8) != 0) {
                    timeBucketList.add(String.format("W|%04d%02d", AbstractDimensionTimeBucketOperator.this.calendar.get(1), AbstractDimensionTimeBucketOperator.this.calendar.get(3)));
                }
                if ((AbstractDimensionTimeBucketOperator.this.timeBucketFlags & 4) != 0) {
                    timeBucketList.add(String.format("D|%04d%02d%02d", AbstractDimensionTimeBucketOperator.this.calendar.get(1), AbstractDimensionTimeBucketOperator.this.calendar.get(2) + 1, AbstractDimensionTimeBucketOperator.this.calendar.get(5)));
                }
                if ((AbstractDimensionTimeBucketOperator.this.timeBucketFlags & 2) != 0) {
                    timeBucketList.add(String.format("h|%04d%02d%02d%02d", AbstractDimensionTimeBucketOperator.this.calendar.get(1), AbstractDimensionTimeBucketOperator.this.calendar.get(2) + 1, AbstractDimensionTimeBucketOperator.this.calendar.get(5), AbstractDimensionTimeBucketOperator.this.calendar.get(11)));
                }
                if ((AbstractDimensionTimeBucketOperator.this.timeBucketFlags & 1) != 0) {
                    timeBucketList.add(String.format("m|%04d%02d%02d%02d%02d", AbstractDimensionTimeBucketOperator.this.calendar.get(1), AbstractDimensionTimeBucketOperator.this.calendar.get(2) + 1, AbstractDimensionTimeBucketOperator.this.calendar.get(5), AbstractDimensionTimeBucketOperator.this.calendar.get(11), AbstractDimensionTimeBucketOperator.this.calendar.get(12)));
                }
                for (String timeBucket : timeBucketList) {
                    for (int[] dimensionCombination : AbstractDimensionTimeBucketOperator.this.dimensionCombinations) {
                        String field = "0";
                        StringBuilder key = new StringBuilder();
                        if (dimensionCombination != null) {
                            for (int d : dimensionCombination) {
                                if (key.length() != 0) {
                                    key.append("|");
                                }
                                key.append(String.valueOf(d)).append(":").append(tuple.get(AbstractDimensionTimeBucketOperator.this.dimensionKeyNames.get(d)).toString());
                            }
                        }
                        AbstractDimensionTimeBucketOperator.this.process(timeBucket, key.toString(), field, 1);
                        for (int i = 0; i < AbstractDimensionTimeBucketOperator.this.valueKeyNames.size(); ++i) {
                            String valueKeyName = (String)AbstractDimensionTimeBucketOperator.this.valueKeyNames.get(i);
                            field = String.valueOf(i + 1);
                            Object value = tuple.get(valueKeyName);
                            Number numberValue = AbstractDimensionTimeBucketOperator.this.extractNumber(valueKeyName, value);
                            AbstractDimensionTimeBucketOperator.this.process(timeBucket, key.toString(), field, numberValue);
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn("Got exception for tuple {}.  Ignoring this tuple.", tuple, (Object)ex);
            }
        }
    };
    @OutputPortFieldAnnotation(optional=false)
    public final transient DefaultOutputPort<Map<String, Map<String, Number>>> out = new DefaultOutputPort();
    private List<String> dimensionKeyNames = new ArrayList<String>();
    private List<String> valueKeyNames = new ArrayList<String>();
    private String timeKeyName;
    private long currentWindowId;
    private long windowWidth = 500L;
    private int timeBucketFlags;
    private transient TimeZone timeZone = TimeZone.getTimeZone("GMT");
    private transient Calendar calendar = new GregorianCalendar(this.timeZone);
    private transient List<int[]> dimensionCombinations = new ArrayList<int[]>();
    private List<Set<String>> dimensionCombinationsSet;
    private transient NumberFormat numberFormat = NumberFormat.getInstance();
    public static final int TIMEBUCKET_MINUTE = 1;
    public static final int TIMEBUCKET_HOUR = 2;
    public static final int TIMEBUCKET_DAY = 4;
    public static final int TIMEBUCKET_WEEK = 8;
    public static final int TIMEBUCKET_MONTH = 16;
    public static final int TIMEBUCKET_YEAR = 32;
    private static final Logger logger = LoggerFactory.getLogger(AbstractDimensionTimeBucketOperator.class);

    protected long extractTimeFromTuple(Map<String, Object> tuple) {
        long time = this.timeKeyName == null ? (this.currentWindowId >>> 32) * 1000L + this.windowWidth * (this.currentWindowId & 0xFFFFFFFFL) : (Long)tuple.get(this.timeKeyName);
        return time;
    }

    protected Number extractNumber(String valueKeyName, Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value == null) {
            return new Long(0L);
        }
        try {
            return this.numberFormat.parse(value.toString());
        }
        catch (ParseException parseException) {
            return new Long(0L);
        }
    }

    public void addCombination(Set<String> keys) throws NoSuchFieldException {
        if (this.dimensionCombinationsSet == null) {
            this.dimensionCombinationsSet = new ArrayList<Set<String>>();
        }
        this.dimensionCombinationsSet.add(keys);
    }

    public void setup(Context.OperatorContext context) {
        super.setup(context);
        if (context != null) {
            this.windowWidth = ((Integer)context.getValue(Context.DAGContext.STREAMING_WINDOW_SIZE_MILLIS)).intValue();
        }
        if (this.dimensionCombinations.isEmpty() && this.dimensionCombinationsSet == null) {
            this.dimensionCombinations.add(null);
            for (int i = 1; i <= this.dimensionKeyNames.size(); ++i) {
                this.dimensionCombinations.addAll(Combinations.getNumberCombinations(this.dimensionKeyNames.size(), i));
            }
        } else if (this.dimensionCombinationsSet != null) {
            for (Set<String> keySet : this.dimensionCombinationsSet) {
                int[] indexKeys = new int[keySet.size()];
                int i = 0;
                for (String key : keySet) {
                    indexKeys[i] = -1;
                    for (int j = 0; j < this.dimensionKeyNames.size(); ++j) {
                        if (!this.dimensionKeyNames.get(j).equals(key)) continue;
                        indexKeys[i] = j;
                        break;
                    }
                    if (indexKeys[i] < 0) {
                        // empty if block
                    }
                    ++i;
                }
                this.dimensionCombinations.add(indexKeys);
            }
        }
        logger.info("number of combinations {}", (Object)this.dimensionCombinations.size());
    }

    public void beginWindow(long windowId) {
        super.beginWindow(windowId);
        this.currentWindowId = windowId;
    }

    public void addDimensionKeyName(String key) {
        this.dimensionKeyNames.add(key);
    }

    public void addValueKeyName(String key) {
        this.valueKeyNames.add(key);
    }

    public void setTimeKeyName(String key) {
        this.timeKeyName = key;
    }

    public void setTimeBucketFlags(int timeBucketFlags) {
        this.timeBucketFlags = timeBucketFlags;
    }

    public void setTimeZone(TimeZone tz) {
        this.timeZone = tz;
        this.calendar.setTimeZone(this.timeZone);
    }

    public abstract void process(String var1, String var2, String var3, Number var4);

    public static class Combinations {
        public static <K> List<List<K>> getCombinations(List<K> list, int r) {
            ArrayList<List<K>> result = new ArrayList<List<K>>();
            List<int[]> combos = Combinations.getNumberCombinations(list.size(), r);
            for (int[] a : combos) {
                ArrayList<K> keys = new ArrayList<K>(r);
                for (int j = 0; j < r; ++j) {
                    keys.add(j, list.get(a[j]));
                }
                result.add(keys);
            }
            return result;
        }

        public static List<int[]> getNumberCombinations(int n, int r) {
            ArrayList<int[]> list = new ArrayList<int[]>();
            int[] res = new int[r];
            for (int i = 0; i < res.length; ++i) {
                res[i] = i;
            }
            boolean done = false;
            while (!done) {
                int[] a = new int[res.length];
                System.arraycopy(res, 0, a, 0, res.length);
                list.add(a);
                done = Combinations.next(res, n, r);
            }
            return list;
        }

        private static boolean next(int[] num, int n, int r) {
            int target;
            int n2 = target = r - 1;
            num[n2] = num[n2] + 1;
            if (num[target] > n - (r - target)) {
                while (num[target] > n - (r - target) - 1 && --target >= 0) {
                }
                if (target < 0) {
                    return true;
                }
                int n3 = target;
                num[n3] = num[n3] + 1;
                for (int i = target + 1; i < num.length; ++i) {
                    num[i] = num[i - 1] + 1;
                }
            }
            return false;
        }

        public static void main(String[] args) {
            String[] list = new String[]{"a", "b", "c", "d", "e"};
            for (int i = 1; i <= list.length; ++i) {
                logger.info("Combinations: {}", Combinations.getCombinations(Arrays.asList(list), i));
            }
        }
    }
}

