/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.Context;
import com.datatorrent.api.StorageAgent;
import com.datatorrent.lib.util.StorageAgentKeyValueStore;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeyValueStorageAgent<S extends StorageAgentKeyValueStore>
implements StorageAgent.ApplicationAwareStorageAgent,
Serializable {
    protected S store;
    protected String applicationId;
    public static final String CHECKPOINT_KEY_SEPARATOR = "-";
    private static final long serialVersionUID = 7065320156997171116L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractKeyValueStorageAgent.class);

    public S getStore() {
        return this.store;
    }

    public void setStore(S store) {
        this.store = store;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public static String generateKey(int operatorId, long windowId) {
        return String.valueOf(operatorId) + CHECKPOINT_KEY_SEPARATOR + String.valueOf(windowId);
    }

    public void save(Object object, int operatorId, long windowId) throws IOException {
        try {
            this.store(AbstractKeyValueStorageAgent.generateKey(operatorId, windowId), object);
            logger.debug("saved check point object key {} region {}", (Object)AbstractKeyValueStorageAgent.generateKey(operatorId, windowId), (Object)this.applicationId);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private synchronized void store(String checkpointKey, Object operator) throws IOException {
        if (!this.getStore().isConnected()) {
            this.getStore().connect();
        }
        this.getStore().put(checkpointKey, operator);
    }

    public Object load(int operatorId, long windowId) {
        Object obj = null;
        try {
            obj = this.retrieve(AbstractKeyValueStorageAgent.generateKey(operatorId, windowId));
            logger.debug("retrieved object from store  key {} region {} ", (Object)AbstractKeyValueStorageAgent.generateKey(operatorId, windowId), (Object)this.applicationId);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return obj;
    }

    private synchronized Object retrieve(String checkpointKey) throws IOException {
        if (!this.getStore().isConnected()) {
            this.getStore().connect();
        }
        return this.getStore().get(checkpointKey);
    }

    public void delete(int operatorId, long windowId) throws IOException {
        if (!this.getStore().isConnected()) {
            this.getStore().connect();
        }
        try {
            this.getStore().remove(AbstractKeyValueStorageAgent.generateKey(operatorId, windowId));
            logger.debug("deleted object from store key {} region {}", (Object)AbstractKeyValueStorageAgent.generateKey(operatorId, windowId));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public long[] getWindowIds(int operatorId) throws IOException {
        List<String> keys;
        if (!this.getStore().isConnected()) {
            this.getStore().connect();
        }
        if ((keys = this.getStore().getKeys(operatorId)).size() > 0) {
            long[] windowsIds = new long[keys.size()];
            int count = 0;
            for (String key : keys) {
                windowsIds[count] = AbstractKeyValueStorageAgent.extractwindowId(key);
                ++count;
            }
            return windowsIds;
        }
        return new long[0];
    }

    public static long extractwindowId(String checkpointKey) {
        String[] parts = checkpointKey.split(CHECKPOINT_KEY_SEPARATOR);
        return Long.parseLong(parts[1]);
    }

    public void setApplicationAttributes(Attribute.AttributeMap map) {
        this.applicationId = (String)map.get(Context.DAGContext.APPLICATION_ID);
        this.getStore().setTableName(this.applicationId);
    }
}

