/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQMessageListener
implements MessageListener,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ActiveMQMessageListener.class);
    private Connection connection;
    private Session session;
    private MessageConsumer consumer;
    private Destination destination;
    protected int countMessages = 0;
    public HashMap<Integer, Object> receivedData = new HashMap();
    private String user = "";
    private String password = "";
    private String url = "tcp://localhost:61617";
    private int ackMode = 2;
    private String subject = "TEST.FOO";
    private int batch = 10;
    private int messageSize = 255;
    private long maximumReceiveMessages = 20L;
    private boolean durable = false;
    private boolean topic = false;
    private boolean transacted = false;
    private boolean verbose = false;
    private String consumerName = "Consumer1";

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setAckMode(int ackMode) {
        this.ackMode = ackMode;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setBatch(int batch) {
        this.batch = batch;
    }

    public void setMessageSize(int messageSize) {
        this.messageSize = messageSize;
    }

    public void setMaximumReceiveMessages(long maximumReceiveMessages) {
        this.maximumReceiveMessages = maximumReceiveMessages;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public void setTopic(boolean topic) {
        this.topic = topic;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public void setupConnection() throws JMSException {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.user, this.password, this.url);
        this.connection = connectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(this.transacted, this.ackMode);
        this.destination = this.topic ? this.session.createTopic(this.subject) : this.session.createQueue(this.subject);
        this.consumer = this.durable && this.topic ? this.session.createDurableSubscriber((Topic)this.destination, this.consumerName) : this.session.createConsumer(this.destination);
        this.consumer.setMessageListener((MessageListener)this);
    }

    public void onMessage(Message message) {
        if ((long)this.countMessages++ >= this.maximumReceiveMessages && this.maximumReceiveMessages != 0L) {
            try {
                logger.warn("Reached maximum receive messages of {}", (Object)this.maximumReceiveMessages);
                this.consumer.setMessageListener(null);
            }
            catch (JMSException ex) {
                logger.debug(ex.getLocalizedMessage());
            }
            return;
        }
    }

    @Override
    public void run() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            logger.debug(ex.getLocalizedMessage());
        }
    }

    public void closeConnection() {
        try {
            this.consumer.close();
            this.session.close();
            this.connection.close();
        }
        catch (JMSException ex) {
            logger.debug(ex.getLocalizedMessage());
        }
    }
}

