/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import com.datatorrent.lib.util.ActiveMQMessageListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQMultiTypeMessageListener
extends ActiveMQMessageListener {
    private static final Logger logger = LoggerFactory.getLogger(ActiveMQMultiTypeMessageListener.class);

    @Override
    public void onMessage(Message message) {
        super.onMessage(message);
        if (message instanceof TextMessage) {
            TextMessage txtMsg = (TextMessage)message;
            String msg = null;
            try {
                msg = txtMsg.getText();
                this.receivedData.put(this.countMessages, msg);
            }
            catch (JMSException ex) {
                logger.debug(ex.getLocalizedMessage());
            }
            logger.debug("Received a TextMessage: {}", (Object)msg);
        } else if (message instanceof MapMessage) {
            MapMessage mapMsg = (MapMessage)message;
            HashMap<String, Object> map = new HashMap<String, Object>();
            try {
                Enumeration en = mapMsg.getMapNames();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    map.put(key, mapMsg.getObject(key));
                }
                this.receivedData.put(this.countMessages, map);
            }
            catch (JMSException ex) {
                logger.debug(ex.getLocalizedMessage());
            }
            logger.debug("Received a MapMessage: {}", map);
        } else if (message instanceof BytesMessage) {
            BytesMessage bytesMsg = (BytesMessage)message;
            try {
                byte[] byteArr = new byte[(int)bytesMsg.getBodyLength()];
                bytesMsg.readBytes(byteArr);
                this.receivedData.put(this.countMessages, byteArr);
            }
            catch (JMSException ex) {
                logger.debug(ex.getLocalizedMessage());
            }
            logger.debug("Received a ByteMessage: {}", (Object)bytesMsg);
        } else if (message instanceof ObjectMessage) {
            ObjectMessage objMsg = (ObjectMessage)message;
            Serializable msg = null;
            try {
                msg = objMsg.getObject();
                this.receivedData.put(this.countMessages, msg);
            }
            catch (JMSException ex) {
                logger.debug(ex.getLocalizedMessage());
            }
            logger.debug("Received an ObjectMessage: {}", (Object)msg);
        } else {
            throw new IllegalArgumentException("Unhandled message type " + message.getClass().getName());
        }
    }
}

