/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import com.datatorrent.lib.util.BaseKeyValueOperator;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class BaseMatchOperator<K, V>
extends BaseKeyValueOperator<K, V> {
    @NotNull
    private K key;
    @Pattern(regexp="lte|lt|eq|ne|gt|gte", message="Value has to be one of lte, lt, eq, ne, gt, gte")
    private double value = 0.0;
    ComparatorFunction comparator = ComparatorFunction.EQ;

    public void setKey(K key) {
        this.key = key;
    }

    @NotNull
    public K getKey() {
        return this.key;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public boolean compareValue(double value) {
        boolean ret;
        switch (this.comparator) {
            case LT: {
                ret = value < this.value;
                break;
            }
            case LTE: {
                ret = value <= this.value;
                break;
            }
            case EQ: {
                ret = value == this.value;
                break;
            }
            case NEQ: {
                ret = value != this.value;
                break;
            }
            case GT: {
                ret = value > this.value;
                break;
            }
            case GTE: {
                ret = value >= this.value;
                break;
            }
            default: {
                ret = value == this.value;
            }
        }
        return ret;
    }

    public void setType(ComparatorFunction type) {
        this.comparator = type;
    }

    public ComparatorFunction getType() {
        return this.comparator;
    }

    @Pattern(regexp="lte|lt|eq|ne|gt|gte", message="Value has to be one of lte, lt, eq, ne, gt, gte")
    public void setCmp(String cmp) {
        if (cmp.equals("lt")) {
            this.setTypeLT();
        } else if (cmp.equals("lte")) {
            this.setTypeLTE();
        } else if (cmp.equals("eq")) {
            this.setTypeEQ();
        } else if (cmp.equals("ne")) {
            this.setTypeEQ();
        } else if (cmp.equals("gt")) {
            this.setTypeGT();
        } else if (cmp.equals("gte")) {
            this.setTypeGTE();
        } else {
            this.setTypeEQ();
        }
    }

    public ComparatorFunction getComparator() {
        return this.comparator;
    }

    public void setComparator(ComparatorFunction comparator) {
        this.comparator = comparator;
    }

    public void setTypeLT() {
        this.comparator = ComparatorFunction.LT;
    }

    public void setTypeLTE() {
        this.comparator = ComparatorFunction.LTE;
    }

    public void setTypeEQ() {
        this.comparator = ComparatorFunction.EQ;
    }

    public void setTypeNEQ() {
        this.comparator = ComparatorFunction.NEQ;
    }

    public void setTypeGT() {
        this.comparator = ComparatorFunction.GT;
    }

    public void setTypeGTE() {
        this.comparator = ComparatorFunction.GTE;
    }

    public static enum ComparatorFunction {
        LTE,
        LT,
        EQ,
        NEQ,
        GT,
        GTE;

    }
}

