/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.util;

import com.datatorrent.lib.util.BaseFilteredKeyValueOperator;
import javax.validation.constraints.NotNull;

public class BaseNumberKeyValueOperator<K, V extends Number>
extends BaseFilteredKeyValueOperator<K, V> {
    @NotNull
    V_TYPE type = V_TYPE.DOUBLE;

    public void setType(Class<V> ctype) {
        this.type = ctype == Double.class ? V_TYPE.DOUBLE : (ctype == Integer.class ? V_TYPE.INTEGER : (ctype == Float.class ? V_TYPE.FLOAT : (ctype == Long.class ? V_TYPE.LONG : (ctype == Short.class ? V_TYPE.SHORT : V_TYPE.UNKNOWN))));
    }

    public V getValue(Number num) {
        Number val;
        switch (this.type) {
            case DOUBLE: {
                val = num.doubleValue();
                break;
            }
            case INTEGER: {
                val = num.intValue();
                break;
            }
            case FLOAT: {
                val = Float.valueOf(num.floatValue());
                break;
            }
            case LONG: {
                val = num.longValue();
                break;
            }
            case SHORT: {
                val = num.shortValue();
                break;
            }
            default: {
                val = num.doubleValue();
            }
        }
        return (V)val;
    }

    public static enum V_TYPE {
        DOUBLE,
        INTEGER,
        FLOAT,
        LONG,
        SHORT,
        UNKNOWN;

    }
}

